package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetKeyOutputBuilder} instances.
 *
 * @see GetKeyOutputBuilder
 *
 */
public class GetKeyOutputBuilder implements Builder<GetKeyOutput> {

    private MappingAuthkey _mappingAuthkey;


    Map<Class<? extends Augmentation<GetKeyOutput>>, Augmentation<GetKeyOutput>> augmentation = Collections.emptyMap();

    public GetKeyOutputBuilder() {
    }
    public GetKeyOutputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer arg) {
        this._mappingAuthkey = arg.getMappingAuthkey();
    }

    public GetKeyOutputBuilder(GetKeyOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<GetKeyOutput>>, Augmentation<GetKeyOutput>> aug =((AugmentationHolder<GetKeyOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._mappingAuthkey = base.getMappingAuthkey();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer) {
            this._mappingAuthkey = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer)arg).getMappingAuthkey();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer]");
    }

    public MappingAuthkey getMappingAuthkey() {
        return _mappingAuthkey;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetKeyOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public GetKeyOutputBuilder setMappingAuthkey(final MappingAuthkey value) {
        this._mappingAuthkey = value;
        return this;
    }
    
    public GetKeyOutputBuilder addAugmentation(Class<? extends Augmentation<GetKeyOutput>> augmentationType, Augmentation<GetKeyOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public GetKeyOutputBuilder removeAugmentation(Class<? extends Augmentation<GetKeyOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public GetKeyOutput build() {
        return new GetKeyOutputImpl(this);
    }

    private static final class GetKeyOutputImpl
        extends AbstractAugmentable<GetKeyOutput>
        implements GetKeyOutput {
    
        private final MappingAuthkey _mappingAuthkey;
    
        GetKeyOutputImpl(GetKeyOutputBuilder base) {
            super(base.augmentation);
            this._mappingAuthkey = base.getMappingAuthkey();
        }
    
        @Override
        public MappingAuthkey getMappingAuthkey() {
            return _mappingAuthkey;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mappingAuthkey);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetKeyOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            GetKeyOutput other = (GetKeyOutput)obj;
            if (!Objects.equals(_mappingAuthkey, other.getMappingAuthkey())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GetKeyOutputImpl otherImpl = (GetKeyOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<GetKeyOutput>>, Augmentation<GetKeyOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("GetKeyOutput");
            CodeHelpers.appendValue(helper, "_mappingAuthkey", _mappingAuthkey);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
