package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.list.EidItem;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetKeysInputBuilder} instances.
 *
 * @see GetKeysInputBuilder
 *
 */
public class GetKeysInputBuilder implements Builder<GetKeysInput> {

    private List<EidItem> _eidItem;


    Map<Class<? extends Augmentation<GetKeysInput>>, Augmentation<GetKeysInput>> augmentation = Collections.emptyMap();

    public GetKeysInputBuilder() {
    }
    public GetKeysInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidList arg) {
        this._eidItem = arg.getEidItem();
    }

    public GetKeysInputBuilder(GetKeysInput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<GetKeysInput>>, Augmentation<GetKeysInput>> aug =((AugmentationHolder<GetKeysInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._eidItem = base.getEidItem();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidList</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidList) {
            this._eidItem = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidList)arg).getEidItem();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidList]");
    }

    public List<EidItem> getEidItem() {
        return _eidItem;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetKeysInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public GetKeysInputBuilder setEidItem(final List<EidItem> values) {
        this._eidItem = values;
        return this;
    }
    
    
    public GetKeysInputBuilder addAugmentation(Class<? extends Augmentation<GetKeysInput>> augmentationType, Augmentation<GetKeysInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public GetKeysInputBuilder removeAugmentation(Class<? extends Augmentation<GetKeysInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public GetKeysInput build() {
        return new GetKeysInputImpl(this);
    }

    private static final class GetKeysInputImpl
        extends AbstractAugmentable<GetKeysInput>
        implements GetKeysInput {
    
        private final List<EidItem> _eidItem;
    
        GetKeysInputImpl(GetKeysInputBuilder base) {
            super(base.augmentation);
            this._eidItem = base.getEidItem();
        }
    
        @Override
        public List<EidItem> getEidItem() {
            return _eidItem;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_eidItem);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetKeysInput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            GetKeysInput other = (GetKeysInput)obj;
            if (!Objects.equals(_eidItem, other.getEidItem())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GetKeysInputImpl otherImpl = (GetKeysInputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<GetKeysInput>>, Augmentation<GetKeysInput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("GetKeysInput");
            CodeHelpers.appendValue(helper, "_eidItem", _eidItem);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
