package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetKeysOutputBuilder} instances.
 *
 * @see GetKeysOutputBuilder
 *
 */
public class GetKeysOutputBuilder implements Builder<GetKeysOutput> {

    private List<EidAuthkeyItem> _eidAuthkeyItem;


    Map<Class<? extends Augmentation<GetKeysOutput>>, Augmentation<GetKeysOutput>> augmentation = Collections.emptyMap();

    public GetKeysOutputBuilder() {
    }
    public GetKeysOutputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidAuthkeyList arg) {
        this._eidAuthkeyItem = arg.getEidAuthkeyItem();
    }

    public GetKeysOutputBuilder(GetKeysOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<GetKeysOutput>>, Augmentation<GetKeysOutput>> aug =((AugmentationHolder<GetKeysOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._eidAuthkeyItem = base.getEidAuthkeyItem();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidAuthkeyList</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidAuthkeyList) {
            this._eidAuthkeyItem = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidAuthkeyList)arg).getEidAuthkeyItem();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidAuthkeyList]");
    }

    public List<EidAuthkeyItem> getEidAuthkeyItem() {
        return _eidAuthkeyItem;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetKeysOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public GetKeysOutputBuilder setEidAuthkeyItem(final List<EidAuthkeyItem> values) {
        this._eidAuthkeyItem = values;
        return this;
    }
    
    
    public GetKeysOutputBuilder addAugmentation(Class<? extends Augmentation<GetKeysOutput>> augmentationType, Augmentation<GetKeysOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public GetKeysOutputBuilder removeAugmentation(Class<? extends Augmentation<GetKeysOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public GetKeysOutput build() {
        return new GetKeysOutputImpl(this);
    }

    private static final class GetKeysOutputImpl
        extends AbstractAugmentable<GetKeysOutput>
        implements GetKeysOutput {
    
        private final List<EidAuthkeyItem> _eidAuthkeyItem;
    
        GetKeysOutputImpl(GetKeysOutputBuilder base) {
            super(base.augmentation);
            this._eidAuthkeyItem = base.getEidAuthkeyItem();
        }
    
        @Override
        public List<EidAuthkeyItem> getEidAuthkeyItem() {
            return _eidAuthkeyItem;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_eidAuthkeyItem);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetKeysOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            GetKeysOutput other = (GetKeysOutput)obj;
            if (!Objects.equals(_eidAuthkeyItem, other.getEidAuthkeyItem())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GetKeysOutputImpl otherImpl = (GetKeysOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<GetKeysOutput>>, Augmentation<GetKeysOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("GetKeysOutput");
            CodeHelpers.appendValue(helper, "_eidAuthkeyItem", _eidAuthkeyItem);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
