package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.XtrId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetMappingWithXtrIdInputBuilder} instances.
 *
 * @see GetMappingWithXtrIdInputBuilder
 *
 */
public class GetMappingWithXtrIdInputBuilder implements Builder<GetMappingWithXtrIdInput> {

    private Eid _eid;
    private XtrId _xtrId;


    Map<Class<? extends Augmentation<GetMappingWithXtrIdInput>>, Augmentation<GetMappingWithXtrIdInput>> augmentation = Collections.emptyMap();

    public GetMappingWithXtrIdInputBuilder() {
    }
    public GetMappingWithXtrIdInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer arg) {
        this._eid = arg.getEid();
    }

    public GetMappingWithXtrIdInputBuilder(GetMappingWithXtrIdInput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<GetMappingWithXtrIdInput>>, Augmentation<GetMappingWithXtrIdInput>> aug =((AugmentationHolder<GetMappingWithXtrIdInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._eid = base.getEid();
        this._xtrId = base.getXtrId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer) {
            this._eid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer)arg).getEid();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer]");
    }

    public Eid getEid() {
        return _eid;
    }
    
    public XtrId getXtrId() {
        return _xtrId;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetMappingWithXtrIdInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public GetMappingWithXtrIdInputBuilder setEid(final Eid value) {
        this._eid = value;
        return this;
    }
    
    public GetMappingWithXtrIdInputBuilder setXtrId(final XtrId value) {
        this._xtrId = value;
        return this;
    }
    
    public GetMappingWithXtrIdInputBuilder addAugmentation(Class<? extends Augmentation<GetMappingWithXtrIdInput>> augmentationType, Augmentation<GetMappingWithXtrIdInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public GetMappingWithXtrIdInputBuilder removeAugmentation(Class<? extends Augmentation<GetMappingWithXtrIdInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public GetMappingWithXtrIdInput build() {
        return new GetMappingWithXtrIdInputImpl(this);
    }

    private static final class GetMappingWithXtrIdInputImpl
        extends AbstractAugmentable<GetMappingWithXtrIdInput>
        implements GetMappingWithXtrIdInput {
    
        private final Eid _eid;
        private final XtrId _xtrId;
    
        GetMappingWithXtrIdInputImpl(GetMappingWithXtrIdInputBuilder base) {
            super(base.augmentation);
            this._eid = base.getEid();
            this._xtrId = base.getXtrId();
        }
    
        @Override
        public Eid getEid() {
            return _eid;
        }
        
        @Override
        public XtrId getXtrId() {
            return _xtrId;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_eid);
            result = prime * result + Objects.hashCode(_xtrId);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetMappingWithXtrIdInput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            GetMappingWithXtrIdInput other = (GetMappingWithXtrIdInput)obj;
            if (!Objects.equals(_eid, other.getEid())) {
                return false;
            }
            if (!Objects.equals(_xtrId, other.getXtrId())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GetMappingWithXtrIdInputImpl otherImpl = (GetMappingWithXtrIdInputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<GetMappingWithXtrIdInput>>, Augmentation<GetMappingWithXtrIdInput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("GetMappingWithXtrIdInput");
            CodeHelpers.appendValue(helper, "_eid", _eid);
            CodeHelpers.appendValue(helper, "_xtrId", _xtrId);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
