package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum MappingChange implements Enumeration {
    Created(0, "created"),
    
    Updated(1, "updated"),
    
    Removed(2, "removed")
    ;

    private static final Map<String, MappingChange> NAME_MAP;
    private static final Map<Integer, MappingChange> VALUE_MAP;

    static {
        final Builder<String, MappingChange> nb = ImmutableMap.builder();
        final Builder<Integer, MappingChange> vb = ImmutableMap.builder();
        for (MappingChange enumItem : MappingChange.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private MappingChange(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding MappingChange item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<MappingChange> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding MappingChange item, or null if no such item exists
     */
    public static MappingChange forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
