package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.DstSubscriberItem;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.SubscriberItem;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Notification sent when a mapping is changed
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * notification mapping-changed {
 *   leaf change-type {
 *     type mapping-change;
 *   }
 *   uses lisp-proto:mapping-record-container;
 *   uses lisp-proto:eid-container;
 *   list subscriber-item {
 *     uses lisp-proto:subscriber-data-grouping;
 *   }
 *   list dst-subscriber-item {
 *     uses lisp-proto:subscriber-data-grouping;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/mapping-changed</i>
 *
 * <p>To create instances of this class use {@link MappingChangedBuilder}.
 * @see MappingChangedBuilder
 *
 */
public interface MappingChanged
    extends
    DataObject,
    Augmentable<MappingChanged>,
    EidContainer,
    MappingRecordContainer,
    Notification
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("mapping-changed");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged.class;
    }
    
    /**
     * The type of change
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChange</code> <code>changeType</code>, or <code>null</code> if not present
     */
    @Nullable MappingChange getChangeType();
    
    /**
     * The list of subscribers to be notified of this change.
     *
     *
     *
     * @return <code>java.util.List</code> <code>subscriberItem</code>, or <code>null</code> if not present
     */
    @Nullable List<SubscriberItem> getSubscriberItem();
    
    /**
     * @return <code>java.util.List</code> <code>subscriberItem</code>, or an empty list if it is not present
     */
    default @NonNull List<SubscriberItem> nonnullSubscriberItem() {
        return CodeHelpers.nonnull(getSubscriberItem());
    }
    
    /**
     * For Src/Dst EIDs, The list of the Dst subscribers to be notified of this change.
     *
     *
     *
     * @return <code>java.util.List</code> <code>dstSubscriberItem</code>, or <code>null</code> if not present
     */
    @Nullable List<DstSubscriberItem> getDstSubscriberItem();
    
    /**
     * @return <code>java.util.List</code> <code>dstSubscriberItem</code>, or an empty list if it is not present
     */
    default @NonNull List<DstSubscriberItem> nonnullDstSubscriberItem() {
        return CodeHelpers.nonnull(getDstSubscriberItem());
    }

}

