package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.DstSubscriberItem;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.SubscriberItem;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link MappingChangedBuilder} instances.
 *
 * @see MappingChangedBuilder
 *
 */
public class MappingChangedBuilder implements Builder<MappingChanged> {

    private MappingChange _changeType;
    private List<DstSubscriberItem> _dstSubscriberItem;
    private Eid _eid;
    private MappingRecord _mappingRecord;
    private List<SubscriberItem> _subscriberItem;


    Map<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>> augmentation = Collections.emptyMap();

    public MappingChangedBuilder() {
    }
    public MappingChangedBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer arg) {
        this._eid = arg.getEid();
    }
    public MappingChangedBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public MappingChangedBuilder(MappingChanged base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>> aug =((AugmentationHolder<MappingChanged>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._changeType = base.getChangeType();
        this._dstSubscriberItem = base.getDstSubscriberItem();
        this._eid = base.getEid();
        this._mappingRecord = base.getMappingRecord();
        this._subscriberItem = base.getSubscriberItem();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer) {
            this._eid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer)arg).getEid();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer) {
            this._mappingRecord = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer)arg).getMappingRecord();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer]");
    }

    public MappingChange getChangeType() {
        return _changeType;
    }
    
    public List<DstSubscriberItem> getDstSubscriberItem() {
        return _dstSubscriberItem;
    }
    
    public Eid getEid() {
        return _eid;
    }
    
    public MappingRecord getMappingRecord() {
        return _mappingRecord;
    }
    
    public List<SubscriberItem> getSubscriberItem() {
        return _subscriberItem;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<MappingChanged>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public MappingChangedBuilder setChangeType(final MappingChange value) {
        this._changeType = value;
        return this;
    }
    public MappingChangedBuilder setDstSubscriberItem(final List<DstSubscriberItem> values) {
        this._dstSubscriberItem = values;
        return this;
    }
    
    
    public MappingChangedBuilder setEid(final Eid value) {
        this._eid = value;
        return this;
    }
    
    public MappingChangedBuilder setMappingRecord(final MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }
    public MappingChangedBuilder setSubscriberItem(final List<SubscriberItem> values) {
        this._subscriberItem = values;
        return this;
    }
    
    
    public MappingChangedBuilder addAugmentation(Class<? extends Augmentation<MappingChanged>> augmentationType, Augmentation<MappingChanged> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public MappingChangedBuilder removeAugmentation(Class<? extends Augmentation<MappingChanged>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public MappingChanged build() {
        return new MappingChangedImpl(this);
    }

    private static final class MappingChangedImpl
        extends AbstractAugmentable<MappingChanged>
        implements MappingChanged {
    
        private final MappingChange _changeType;
        private final List<DstSubscriberItem> _dstSubscriberItem;
        private final Eid _eid;
        private final MappingRecord _mappingRecord;
        private final List<SubscriberItem> _subscriberItem;
    
        MappingChangedImpl(MappingChangedBuilder base) {
            super(base.augmentation);
            this._changeType = base.getChangeType();
            this._dstSubscriberItem = base.getDstSubscriberItem();
            this._eid = base.getEid();
            this._mappingRecord = base.getMappingRecord();
            this._subscriberItem = base.getSubscriberItem();
        }
    
        @Override
        public MappingChange getChangeType() {
            return _changeType;
        }
        
        @Override
        public List<DstSubscriberItem> getDstSubscriberItem() {
            return _dstSubscriberItem;
        }
        
        @Override
        public Eid getEid() {
            return _eid;
        }
        
        @Override
        public MappingRecord getMappingRecord() {
            return _mappingRecord;
        }
        
        @Override
        public List<SubscriberItem> getSubscriberItem() {
            return _subscriberItem;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_changeType);
            result = prime * result + Objects.hashCode(_dstSubscriberItem);
            result = prime * result + Objects.hashCode(_eid);
            result = prime * result + Objects.hashCode(_mappingRecord);
            result = prime * result + Objects.hashCode(_subscriberItem);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MappingChanged.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            MappingChanged other = (MappingChanged)obj;
            if (!Objects.equals(_changeType, other.getChangeType())) {
                return false;
            }
            if (!Objects.equals(_dstSubscriberItem, other.getDstSubscriberItem())) {
                return false;
            }
            if (!Objects.equals(_eid, other.getEid())) {
                return false;
            }
            if (!Objects.equals(_mappingRecord, other.getMappingRecord())) {
                return false;
            }
            if (!Objects.equals(_subscriberItem, other.getSubscriberItem())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                MappingChangedImpl otherImpl = (MappingChangedImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("MappingChanged");
            CodeHelpers.appendValue(helper, "_changeType", _changeType);
            CodeHelpers.appendValue(helper, "_dstSubscriberItem", _dstSubscriberItem);
            CodeHelpers.appendValue(helper, "_eid", _eid);
            CodeHelpers.appendValue(helper, "_mappingRecord", _mappingRecord);
            CodeHelpers.appendValue(helper, "_subscriberItem", _subscriberItem);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
