package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.LastUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The LISP EID-to-RLOC mapping database
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * container mapping-database {
 *   list virtual-network-identifier {
 *     key vni;
 *     ext:context-instance vni-context;
 *     uses db-instance;
 *   }
 *   container last-updated {
 *     config false;
 *     leaf last-updated {
 *       type int64;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/mapping-database</i>
 *
 * <p>To create instances of this class use {@link MappingDatabaseBuilder}.
 * @see MappingDatabaseBuilder
 *
 */
public interface MappingDatabase
    extends
    ChildOf<OdlMappingserviceData>,
    Augmentable<MappingDatabase>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("mapping-database");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase.class;
    }
    
    /**
     * A list of Virtual Network Identifiers
     *
     *
     *
     * @return <code>java.util.List</code> <code>virtualNetworkIdentifier</code>, or <code>null</code> if not present
     */
    @Nullable List<VirtualNetworkIdentifier> getVirtualNetworkIdentifier();
    
    /**
     * @return <code>java.util.List</code> <code>virtualNetworkIdentifier</code>, or an empty list if it is not present
     */
    default @NonNull List<VirtualNetworkIdentifier> nonnullVirtualNetworkIdentifier() {
        return CodeHelpers.nonnull(getVirtualNetworkIdentifier());
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.LastUpdated</code> <code>lastUpdated</code>, or <code>null</code> if not present
     */
    @Nullable LastUpdated getLastUpdated();

}

