package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.LastUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link MappingDatabaseBuilder} instances.
 *
 * @see MappingDatabaseBuilder
 *
 */
public class MappingDatabaseBuilder implements Builder<MappingDatabase> {

    private LastUpdated _lastUpdated;
    private List<VirtualNetworkIdentifier> _virtualNetworkIdentifier;


    Map<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> augmentation = Collections.emptyMap();

    public MappingDatabaseBuilder() {
    }

    public MappingDatabaseBuilder(MappingDatabase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> aug =((AugmentationHolder<MappingDatabase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._lastUpdated = base.getLastUpdated();
        this._virtualNetworkIdentifier = base.getVirtualNetworkIdentifier();
    }


    public LastUpdated getLastUpdated() {
        return _lastUpdated;
    }
    
    public List<VirtualNetworkIdentifier> getVirtualNetworkIdentifier() {
        return _virtualNetworkIdentifier;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<MappingDatabase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public MappingDatabaseBuilder setLastUpdated(final LastUpdated value) {
        this._lastUpdated = value;
        return this;
    }
    public MappingDatabaseBuilder setVirtualNetworkIdentifier(final List<VirtualNetworkIdentifier> values) {
        this._virtualNetworkIdentifier = values;
        return this;
    }
    
    
    public MappingDatabaseBuilder addAugmentation(Class<? extends Augmentation<MappingDatabase>> augmentationType, Augmentation<MappingDatabase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public MappingDatabaseBuilder removeAugmentation(Class<? extends Augmentation<MappingDatabase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public MappingDatabase build() {
        return new MappingDatabaseImpl(this);
    }

    private static final class MappingDatabaseImpl
        extends AbstractAugmentable<MappingDatabase>
        implements MappingDatabase {
    
        private final LastUpdated _lastUpdated;
        private final List<VirtualNetworkIdentifier> _virtualNetworkIdentifier;
    
        MappingDatabaseImpl(MappingDatabaseBuilder base) {
            super(base.augmentation);
            this._lastUpdated = base.getLastUpdated();
            this._virtualNetworkIdentifier = base.getVirtualNetworkIdentifier();
        }
    
        @Override
        public LastUpdated getLastUpdated() {
            return _lastUpdated;
        }
        
        @Override
        public List<VirtualNetworkIdentifier> getVirtualNetworkIdentifier() {
            return _virtualNetworkIdentifier;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_lastUpdated);
            result = prime * result + Objects.hashCode(_virtualNetworkIdentifier);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MappingDatabase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            MappingDatabase other = (MappingDatabase)obj;
            if (!Objects.equals(_lastUpdated, other.getLastUpdated())) {
                return false;
            }
            if (!Objects.equals(_virtualNetworkIdentifier, other.getVirtualNetworkIdentifier())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                MappingDatabaseImpl otherImpl = (MappingDatabaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("MappingDatabase");
            CodeHelpers.appendValue(helper, "_lastUpdated", _lastUpdated);
            CodeHelpers.appendValue(helper, "_virtualNetworkIdentifier", _virtualNetworkIdentifier);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
