package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * An MD-SAL based implementation of a LISP Map-Server database
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * module odl-mappingservice {
 *   yang-version 1;
 *   namespace urn:opendaylight:lfm:mappingservice;
 *   prefix mappingservice;
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   import yang-ext {
 *     prefix ext;
 *     revision-date 2013-07-09;
 *   }
 *   import odl-lisp-proto {
 *     prefix lisp-proto;
 *     revision-date 2015-11-05;
 *   }
 *   revision 2015-09-06 {
 *   }
 *   typedef mapping-origin {
 *     type enumeration {
 *       enum northbound;
 *       enum southbound;
 *     }
 *   }
 *   typedef vni-uri {
 *     type inet:uri;
 *   }
 *   typedef eid-uri {
 *     type inet:uri;
 *   }
 *   typedef xtr-id-uri {
 *     type inet:uri;
 *   }
 *   typedef mapping-change {
 *     type enumeration {
 *       enum created;
 *       enum updated;
 *       enum removed;
 *     }
 *   }
 *   identity vni-context {
 *   }
 *   identity eid-context {
 *   }
 *   identity xtrid-context {
 *   }
 *   grouping mapping-authkey-list {
 *     list mapping-authkey-item {
 *       key mapping-authkey-item-id;
 *       leaf mapping-authkey-item-id {
 *         type string;
 *       }
 *       uses lisp-proto:mapping-authkey-container;
 *     }
 *   }
 *   grouping eid-authkey-list {
 *     list eid-authkey-item {
 *       key eid-authkey-item-id;
 *       leaf eid-authkey-item-id {
 *         type string;
 *       }
 *       uses lisp-proto:eid-container;
 *       uses lisp-proto:mapping-authkey-container;
 *     }
 *   }
 *   grouping db-instance {
 *     leaf vni {
 *       type vni-uri;
 *     }
 *     list mapping {
 *       key "eid-uri origin";
 *       ext:context-instance eid-context;
 *       leaf eid-uri {
 *         type eid-uri;
 *       }
 *       leaf origin {
 *         type mapping-origin;
 *       }
 *       leaf-list site-id {
 *         type lisp-proto:site-id;
 *       }
 *       uses lisp-proto:mapping-record-container;
 *       list xtr-id-mapping {
 *         config false;
 *         key xtr-id-uri;
 *         ext:context-instance xtrid-context;
 *         leaf xtr-id-uri {
 *           type xtr-id-uri;
 *         }
 *         uses lisp-proto:mapping-record-container;
 *       }
 *     }
 *     list authentication-key {
 *       key eid-uri;
 *       ext:context-instance eid-context;
 *       leaf eid-uri {
 *         type eid-uri;
 *       }
 *       uses lisp-proto:eid-container;
 *       uses lisp-proto:mapping-authkey-container;
 *     }
 *   }
 *   container mapping-database {
 *     list virtual-network-identifier {
 *       key vni;
 *       ext:context-instance vni-context;
 *       uses db-instance;
 *     }
 *     container last-updated {
 *       config false;
 *       leaf last-updated {
 *         type int64;
 *       }
 *     }
 *   }
 *   rpc add-key {
 *     input {
 *       uses lisp-proto:eid-container;
 *       uses lisp-proto:mapping-authkey-container;
 *     }
 *     output;
 *   }
 *   rpc get-key {
 *     input {
 *       uses lisp-proto:eid-container;
 *     }
 *     output {
 *       uses lisp-proto:mapping-authkey-container;
 *     }
 *   }
 *   rpc update-key {
 *     input {
 *       uses lisp-proto:eid-container;
 *       uses lisp-proto:mapping-authkey-container;
 *     }
 *     output;
 *   }
 *   rpc remove-key {
 *     input {
 *       uses lisp-proto:eid-container;
 *     }
 *     output;
 *   }
 *   rpc add-mapping {
 *     input {
 *       uses lisp-proto:mapping-record-container;
 *     }
 *     output;
 *   }
 *   rpc get-mapping {
 *     input {
 *       uses lisp-proto:eid-container;
 *     }
 *     output {
 *       uses lisp-proto:mapping-record-container;
 *     }
 *   }
 *   rpc get-mapping-with-xtr-id {
 *     input {
 *       uses lisp-proto:eid-container;
 *       leaf xtr-id {
 *         type lisp-proto:xtr-id;
 *       }
 *     }
 *     output {
 *       uses lisp-proto:mapping-record-container;
 *     }
 *   }
 *   rpc update-mapping {
 *     input {
 *       uses lisp-proto:mapping-record-container;
 *     }
 *     output;
 *   }
 *   rpc remove-mapping {
 *     input {
 *       uses lisp-proto:eid-container;
 *     }
 *     output;
 *   }
 *   rpc add-keys {
 *     input {
 *       uses eid-authkey-list;
 *     }
 *     output;
 *   }
 *   rpc get-keys {
 *     input {
 *       uses lisp-proto:eid-list;
 *     }
 *     output {
 *       uses eid-authkey-list;
 *     }
 *   }
 *   rpc update-keys {
 *     input {
 *       uses eid-authkey-list;
 *     }
 *     output;
 *   }
 *   rpc remove-keys {
 *     input {
 *       uses lisp-proto:eid-list;
 *     }
 *     output;
 *   }
 *   rpc add-mappings {
 *     input {
 *       uses lisp-proto:mapping-record-list;
 *     }
 *     output;
 *   }
 *   rpc get-mappings {
 *     input {
 *       uses lisp-proto:eid-list;
 *     }
 *     output {
 *       uses lisp-proto:mapping-record-list;
 *     }
 *   }
 *   rpc update-mappings {
 *     input {
 *       uses lisp-proto:mapping-record-list;
 *     }
 *     output;
 *   }
 *   rpc remove-mappings {
 *     input {
 *       uses lisp-proto:eid-list;
 *     }
 *     output;
 *   }
 *   rpc get-all-keys {
 *     output {
 *       uses eid-authkey-list;
 *     }
 *     input;
 *   }
 *   rpc get-all-mappings {
 *     output {
 *       uses lisp-proto:mapping-record-list;
 *     }
 *     input;
 *   }
 *   rpc remove-all-keys {
 *     input;
 *     output;
 *   }
 *   rpc remove-all-mappings {
 *     input;
 *     output;
 *   }
 *   rpc remove-all-operational-content {
 *     input;
 *     output;
 *   }
 *   notification mapping-changed {
 *     leaf change-type {
 *       type mapping-change;
 *     }
 *     uses lisp-proto:mapping-record-container;
 *     uses lisp-proto:eid-container;
 *     list subscriber-item {
 *       uses lisp-proto:subscriber-data-grouping;
 *     }
 *     list dst-subscriber-item {
 *       uses lisp-proto:subscriber-data-grouping;
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface OdlMappingserviceData
    extends
    DataRoot
{




    /**
     * The LISP EID-to-RLOC mapping database
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase</code> <code>mappingDatabase</code>, or <code>null</code> if not present
     */
    @Nullable MappingDatabase getMappingDatabase();

}

