package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for implementing the following YANG notifications defined in module <b>odl-mappingservice</b>
 * <pre>
 * notification mapping-changed {
 *   leaf change-type {
 *     type mapping-change;
 *   }
 *   uses lisp-proto:mapping-record-container;
 *   uses lisp-proto:eid-container;
 *   list subscriber-item {
 *     uses lisp-proto:subscriber-data-grouping;
 *   }
 *   list dst-subscriber-item {
 *     uses lisp-proto:subscriber-data-grouping;
 *   }
 * }
 * </pre>
 *
 */
public interface OdlMappingserviceListener
    extends
    NotificationListener
{




    /**
     * Notification sent when a mapping is changed
     *
     */
    void onMappingChanged(MappingChanged notification);

}

