package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>odl-mappingservice</b>
 * <pre>
 * rpc remove-all-mappings {
 *   input;
 *   output;
 * }
 * rpc get-all-keys {
 *   output {
 *     uses eid-authkey-list;
 *   }
 *   input;
 * }
 * rpc remove-all-keys {
 *   input;
 *   output;
 * }
 * rpc get-mapping-with-xtr-id {
 *   input {
 *     uses lisp-proto:eid-container;
 *     leaf xtr-id {
 *       type lisp-proto:xtr-id;
 *     }
 *   }
 *   output {
 *     uses lisp-proto:mapping-record-container;
 *   }
 * }
 * rpc update-key {
 *   input {
 *     uses lisp-proto:eid-container;
 *     uses lisp-proto:mapping-authkey-container;
 *   }
 *   output;
 * }
 * rpc get-mapping {
 *   input {
 *     uses lisp-proto:eid-container;
 *   }
 *   output {
 *     uses lisp-proto:mapping-record-container;
 *   }
 * }
 * rpc get-mappings {
 *   input {
 *     uses lisp-proto:eid-list;
 *   }
 *   output {
 *     uses lisp-proto:mapping-record-list;
 *   }
 * }
 * rpc get-keys {
 *   input {
 *     uses lisp-proto:eid-list;
 *   }
 *   output {
 *     uses eid-authkey-list;
 *   }
 * }
 * rpc remove-mappings {
 *   input {
 *     uses lisp-proto:eid-list;
 *   }
 *   output;
 * }
 * rpc get-key {
 *   input {
 *     uses lisp-proto:eid-container;
 *   }
 *   output {
 *     uses lisp-proto:mapping-authkey-container;
 *   }
 * }
 * rpc remove-keys {
 *   input {
 *     uses lisp-proto:eid-list;
 *   }
 *   output;
 * }
 * rpc get-all-mappings {
 *   output {
 *     uses lisp-proto:mapping-record-list;
 *   }
 *   input;
 * }
 * rpc add-keys {
 *   input {
 *     uses eid-authkey-list;
 *   }
 *   output;
 * }
 * rpc remove-key {
 *   input {
 *     uses lisp-proto:eid-container;
 *   }
 *   output;
 * }
 * rpc update-mappings {
 *   input {
 *     uses lisp-proto:mapping-record-list;
 *   }
 *   output;
 * }
 * rpc remove-all-operational-content {
 *   input;
 *   output;
 * }
 * rpc remove-mapping {
 *   input {
 *     uses lisp-proto:eid-container;
 *   }
 *   output;
 * }
 * rpc update-keys {
 *   input {
 *     uses eid-authkey-list;
 *   }
 *   output;
 * }
 * rpc add-mappings {
 *   input {
 *     uses lisp-proto:mapping-record-list;
 *   }
 *   output;
 * }
 * rpc add-mapping {
 *   input {
 *     uses lisp-proto:mapping-record-container;
 *   }
 *   output;
 * }
 * rpc add-key {
 *   input {
 *     uses lisp-proto:eid-container;
 *     uses lisp-proto:mapping-authkey-container;
 *   }
 *   output;
 * }
 * rpc update-mapping {
 *   input {
 *     uses lisp-proto:mapping-record-container;
 *   }
 *   output;
 * }
 * </pre>
 *
 */
public interface OdlMappingserviceService
    extends
    RpcService
{




    @CheckReturnValue
    ListenableFuture<RpcResult<RemoveAllMappingsOutput>> removeAllMappings(RemoveAllMappingsInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<GetAllKeysOutput>> getAllKeys(GetAllKeysInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<RemoveAllKeysOutput>> removeAllKeys(RemoveAllKeysInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<GetMappingWithXtrIdOutput>> getMappingWithXtrId(GetMappingWithXtrIdInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<UpdateKeyOutput>> updateKey(UpdateKeyInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<GetMappingOutput>> getMapping(GetMappingInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<GetMappingsOutput>> getMappings(GetMappingsInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<GetKeysOutput>> getKeys(GetKeysInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<RemoveMappingsOutput>> removeMappings(RemoveMappingsInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<GetKeyOutput>> getKey(GetKeyInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<RemoveKeysOutput>> removeKeys(RemoveKeysInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<GetAllMappingsOutput>> getAllMappings(GetAllMappingsInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<AddKeysOutput>> addKeys(AddKeysInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<RemoveKeyOutput>> removeKey(RemoveKeyInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<UpdateMappingsOutput>> updateMappings(UpdateMappingsInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<RemoveAllOperationalContentOutput>> removeAllOperationalContent(RemoveAllOperationalContentInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<RemoveMappingOutput>> removeMapping(RemoveMappingInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<UpdateKeysOutput>> updateKeys(UpdateKeysInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<AddMappingsOutput>> addMappings(AddMappingsInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<AddMappingOutput>> addMapping(AddMappingInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<AddKeyOutput>> addKey(AddKeyInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<UpdateMappingOutput>> updateMapping(UpdateMappingInput input);

}

