package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RemoveAllOperationalContentOutputBuilder} instances.
 *
 * @see RemoveAllOperationalContentOutputBuilder
 *
 */
public class RemoveAllOperationalContentOutputBuilder implements Builder<RemoveAllOperationalContentOutput> {



    Map<Class<? extends Augmentation<RemoveAllOperationalContentOutput>>, Augmentation<RemoveAllOperationalContentOutput>> augmentation = Collections.emptyMap();

    public RemoveAllOperationalContentOutputBuilder() {
    }

    public RemoveAllOperationalContentOutputBuilder(RemoveAllOperationalContentOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<RemoveAllOperationalContentOutput>>, Augmentation<RemoveAllOperationalContentOutput>> aug =((AugmentationHolder<RemoveAllOperationalContentOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }



    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RemoveAllOperationalContentOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public RemoveAllOperationalContentOutputBuilder addAugmentation(Class<? extends Augmentation<RemoveAllOperationalContentOutput>> augmentationType, Augmentation<RemoveAllOperationalContentOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RemoveAllOperationalContentOutputBuilder removeAugmentation(Class<? extends Augmentation<RemoveAllOperationalContentOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RemoveAllOperationalContentOutput build() {
        return new RemoveAllOperationalContentOutputImpl(this);
    }

    private static final class RemoveAllOperationalContentOutputImpl
        extends AbstractAugmentable<RemoveAllOperationalContentOutput>
        implements RemoveAllOperationalContentOutput {
    
    
        RemoveAllOperationalContentOutputImpl(RemoveAllOperationalContentOutputBuilder base) {
            super(base.augmentation);
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RemoveAllOperationalContentOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            RemoveAllOperationalContentOutput other = (RemoveAllOperationalContentOutput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RemoveAllOperationalContentOutputImpl otherImpl = (RemoveAllOperationalContentOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<RemoveAllOperationalContentOutput>>, Augmentation<RemoveAllOperationalContentOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RemoveAllOperationalContentOutput");
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
