package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RemoveKeyOutputBuilder} instances.
 *
 * @see RemoveKeyOutputBuilder
 *
 */
public class RemoveKeyOutputBuilder implements Builder<RemoveKeyOutput> {



    Map<Class<? extends Augmentation<RemoveKeyOutput>>, Augmentation<RemoveKeyOutput>> augmentation = Collections.emptyMap();

    public RemoveKeyOutputBuilder() {
    }

    public RemoveKeyOutputBuilder(RemoveKeyOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<RemoveKeyOutput>>, Augmentation<RemoveKeyOutput>> aug =((AugmentationHolder<RemoveKeyOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }



    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RemoveKeyOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public RemoveKeyOutputBuilder addAugmentation(Class<? extends Augmentation<RemoveKeyOutput>> augmentationType, Augmentation<RemoveKeyOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RemoveKeyOutputBuilder removeAugmentation(Class<? extends Augmentation<RemoveKeyOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RemoveKeyOutput build() {
        return new RemoveKeyOutputImpl(this);
    }

    private static final class RemoveKeyOutputImpl
        extends AbstractAugmentable<RemoveKeyOutput>
        implements RemoveKeyOutput {
    
    
        RemoveKeyOutputImpl(RemoveKeyOutputBuilder base) {
            super(base.augmentation);
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RemoveKeyOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            RemoveKeyOutput other = (RemoveKeyOutput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RemoveKeyOutputImpl otherImpl = (RemoveKeyOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<RemoveKeyOutput>>, Augmentation<RemoveKeyOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RemoveKeyOutput");
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
