package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RemoveMappingOutputBuilder} instances.
 *
 * @see RemoveMappingOutputBuilder
 *
 */
public class RemoveMappingOutputBuilder implements Builder<RemoveMappingOutput> {



    Map<Class<? extends Augmentation<RemoveMappingOutput>>, Augmentation<RemoveMappingOutput>> augmentation = Collections.emptyMap();

    public RemoveMappingOutputBuilder() {
    }

    public RemoveMappingOutputBuilder(RemoveMappingOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<RemoveMappingOutput>>, Augmentation<RemoveMappingOutput>> aug =((AugmentationHolder<RemoveMappingOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }



    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RemoveMappingOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public RemoveMappingOutputBuilder addAugmentation(Class<? extends Augmentation<RemoveMappingOutput>> augmentationType, Augmentation<RemoveMappingOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RemoveMappingOutputBuilder removeAugmentation(Class<? extends Augmentation<RemoveMappingOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RemoveMappingOutput build() {
        return new RemoveMappingOutputImpl(this);
    }

    private static final class RemoveMappingOutputImpl
        extends AbstractAugmentable<RemoveMappingOutput>
        implements RemoveMappingOutput {
    
    
        RemoveMappingOutputImpl(RemoveMappingOutputBuilder base) {
            super(base.augmentation);
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RemoveMappingOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            RemoveMappingOutput other = (RemoveMappingOutput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RemoveMappingOutputImpl otherImpl = (RemoveMappingOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<RemoveMappingOutput>>, Augmentation<RemoveMappingOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RemoveMappingOutput");
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
