package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link UpdateMappingOutputBuilder} instances.
 *
 * @see UpdateMappingOutputBuilder
 *
 */
public class UpdateMappingOutputBuilder implements Builder<UpdateMappingOutput> {



    Map<Class<? extends Augmentation<UpdateMappingOutput>>, Augmentation<UpdateMappingOutput>> augmentation = Collections.emptyMap();

    public UpdateMappingOutputBuilder() {
    }

    public UpdateMappingOutputBuilder(UpdateMappingOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<UpdateMappingOutput>>, Augmentation<UpdateMappingOutput>> aug =((AugmentationHolder<UpdateMappingOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }



    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<UpdateMappingOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public UpdateMappingOutputBuilder addAugmentation(Class<? extends Augmentation<UpdateMappingOutput>> augmentationType, Augmentation<UpdateMappingOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public UpdateMappingOutputBuilder removeAugmentation(Class<? extends Augmentation<UpdateMappingOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public UpdateMappingOutput build() {
        return new UpdateMappingOutputImpl(this);
    }

    private static final class UpdateMappingOutputImpl
        extends AbstractAugmentable<UpdateMappingOutput>
        implements UpdateMappingOutput {
    
    
        UpdateMappingOutputImpl(UpdateMappingOutputBuilder base) {
            super(base.augmentation);
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdateMappingOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            UpdateMappingOutput other = (UpdateMappingOutput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                UpdateMappingOutputImpl otherImpl = (UpdateMappingOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<UpdateMappingOutput>>, Augmentation<UpdateMappingOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("UpdateMappingOutput");
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
