package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link UpdateMappingsOutputBuilder} instances.
 *
 * @see UpdateMappingsOutputBuilder
 *
 */
public class UpdateMappingsOutputBuilder implements Builder<UpdateMappingsOutput> {



    Map<Class<? extends Augmentation<UpdateMappingsOutput>>, Augmentation<UpdateMappingsOutput>> augmentation = Collections.emptyMap();

    public UpdateMappingsOutputBuilder() {
    }

    public UpdateMappingsOutputBuilder(UpdateMappingsOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<UpdateMappingsOutput>>, Augmentation<UpdateMappingsOutput>> aug =((AugmentationHolder<UpdateMappingsOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }



    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<UpdateMappingsOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public UpdateMappingsOutputBuilder addAugmentation(Class<? extends Augmentation<UpdateMappingsOutput>> augmentationType, Augmentation<UpdateMappingsOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public UpdateMappingsOutputBuilder removeAugmentation(Class<? extends Augmentation<UpdateMappingsOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public UpdateMappingsOutput build() {
        return new UpdateMappingsOutputImpl(this);
    }

    private static final class UpdateMappingsOutputImpl
        extends AbstractAugmentable<UpdateMappingsOutput>
        implements UpdateMappingsOutput {
    
    
        UpdateMappingsOutputImpl(UpdateMappingsOutputBuilder base) {
            super(base.augmentation);
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdateMappingsOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            UpdateMappingsOutput other = (UpdateMappingsOutput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                UpdateMappingsOutputImpl otherImpl = (UpdateMappingsOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<UpdateMappingsOutput>>, Augmentation<UpdateMappingsOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("UpdateMappingsOutput");
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
