package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A list of authentication keys for EID prefixes within the same Virtual Network 
 * Identifier
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * list authentication-key {
 *   key eid-uri;
 *   ext:context-instance eid-context;
 *   leaf eid-uri {
 *     type eid-uri;
 *   }
 *   uses lisp-proto:eid-container;
 *   uses lisp-proto:mapping-authkey-container;
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/db-instance/authentication-key</i>
 *
 * <p>To create instances of this class use {@link AuthenticationKeyBuilder}.
 * @see AuthenticationKeyBuilder
 * @see AuthenticationKeyKey
 *
 */
public interface AuthenticationKey
    extends
    ChildOf<DbInstance>,
    Augmentable<AuthenticationKey>,
    EidContainer,
    MappingAuthkeyContainer,
    Identifiable<AuthenticationKeyKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("authentication-key");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri</code> <code>eidUri</code>, or <code>null</code> if not present
     */
    @Nullable EidUri getEidUri();
    
    @Override
    AuthenticationKeyKey key();

}

