package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link AuthenticationKeyBuilder} instances.
 *
 * @see AuthenticationKeyBuilder
 *
 */
public class AuthenticationKeyBuilder implements Builder<AuthenticationKey> {

    private Eid _eid;
    private EidUri _eidUri;
    private MappingAuthkey _mappingAuthkey;
    private AuthenticationKeyKey key;


    Map<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> augmentation = Collections.emptyMap();

    public AuthenticationKeyBuilder() {
    }
    public AuthenticationKeyBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer arg) {
        this._eid = arg.getEid();
    }
    public AuthenticationKeyBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer arg) {
        this._mappingAuthkey = arg.getMappingAuthkey();
    }

    public AuthenticationKeyBuilder(AuthenticationKey base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> aug =((AugmentationHolder<AuthenticationKey>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this.key = base.key();
        this._eidUri = base.getEidUri();
        this._eid = base.getEid();
        this._mappingAuthkey = base.getMappingAuthkey();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer) {
            this._eid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer)arg).getEid();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer) {
            this._mappingAuthkey = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer)arg).getMappingAuthkey();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer]");
    }

    public AuthenticationKeyKey key() {
        return key;
    }
    
    public Eid getEid() {
        return _eid;
    }
    
    public EidUri getEidUri() {
        return _eidUri;
    }
    
    public MappingAuthkey getMappingAuthkey() {
        return _mappingAuthkey;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AuthenticationKey>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public AuthenticationKeyBuilder withKey(final AuthenticationKeyKey key) {
        this.key = key;
        return this;
    }
    
    public AuthenticationKeyBuilder setEid(final Eid value) {
        this._eid = value;
        return this;
    }
    
    public AuthenticationKeyBuilder setEidUri(final EidUri value) {
        this._eidUri = value;
        return this;
    }
    
    public AuthenticationKeyBuilder setMappingAuthkey(final MappingAuthkey value) {
        this._mappingAuthkey = value;
        return this;
    }
    
    public AuthenticationKeyBuilder addAugmentation(Class<? extends Augmentation<AuthenticationKey>> augmentationType, Augmentation<AuthenticationKey> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public AuthenticationKeyBuilder removeAugmentation(Class<? extends Augmentation<AuthenticationKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public AuthenticationKey build() {
        return new AuthenticationKeyImpl(this);
    }

    private static final class AuthenticationKeyImpl
        extends AbstractAugmentable<AuthenticationKey>
        implements AuthenticationKey {
    
        private final Eid _eid;
        private final EidUri _eidUri;
        private final MappingAuthkey _mappingAuthkey;
        private final AuthenticationKeyKey key;
    
        AuthenticationKeyImpl(AuthenticationKeyBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new AuthenticationKeyKey(base.getEidUri());
            }
            this._eidUri = key.getEidUri();
            this._eid = base.getEid();
            this._mappingAuthkey = base.getMappingAuthkey();
        }
    
        @Override
        public AuthenticationKeyKey key() {
            return key;
        }
        
        @Override
        public Eid getEid() {
            return _eid;
        }
        
        @Override
        public EidUri getEidUri() {
            return _eidUri;
        }
        
        @Override
        public MappingAuthkey getMappingAuthkey() {
            return _mappingAuthkey;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_eid);
            result = prime * result + Objects.hashCode(_eidUri);
            result = prime * result + Objects.hashCode(_mappingAuthkey);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AuthenticationKey.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            AuthenticationKey other = (AuthenticationKey)obj;
            if (!Objects.equals(_eid, other.getEid())) {
                return false;
            }
            if (!Objects.equals(_eidUri, other.getEidUri())) {
                return false;
            }
            if (!Objects.equals(_mappingAuthkey, other.getMappingAuthkey())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                AuthenticationKeyImpl otherImpl = (AuthenticationKeyImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("AuthenticationKey");
            CodeHelpers.appendValue(helper, "_eid", _eid);
            CodeHelpers.appendValue(helper, "_eidUri", _eidUri);
            CodeHelpers.appendValue(helper, "_mappingAuthkey", _mappingAuthkey);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
