package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class AuthenticationKeyKey
 implements Identifier<AuthenticationKey> {
    private static final long serialVersionUID = 1037997786839588133L;
    private final EidUri _eidUri;


    public AuthenticationKeyKey(EidUri _eidUri) {
    
    
        this._eidUri = _eidUri;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public AuthenticationKeyKey(AuthenticationKeyKey source) {
        this._eidUri = source._eidUri;
    }


    public EidUri getEidUri() {
        return _eidUri;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_eidUri);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        AuthenticationKeyKey other = (AuthenticationKeyKey) obj;
        if (!Objects.equals(_eidUri, other._eidUri)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(AuthenticationKeyKey.class);
        CodeHelpers.appendValue(helper, "_eidUri", _eidUri);
        return helper.toString();
    }
}

