package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SiteId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A list of EID-to-RLOC mappings within the same Instance ID
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * list mapping {
 *   key "eid-uri origin";
 *   ext:context-instance eid-context;
 *   leaf eid-uri {
 *     type eid-uri;
 *   }
 *   leaf origin {
 *     type mapping-origin;
 *   }
 *   leaf-list site-id {
 *     type lisp-proto:site-id;
 *   }
 *   uses lisp-proto:mapping-record-container;
 *   list xtr-id-mapping {
 *     config false;
 *     key xtr-id-uri;
 *     ext:context-instance xtrid-context;
 *     leaf xtr-id-uri {
 *       type xtr-id-uri;
 *     }
 *     uses lisp-proto:mapping-record-container;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/db-instance/mapping</i>
 *
 * <p>To create instances of this class use {@link MappingBuilder}.
 * @see MappingBuilder
 * @see MappingKey
 *
 */
public interface Mapping
    extends
    ChildOf<DbInstance>,
    Augmentable<Mapping>,
    MappingRecordContainer,
    Identifiable<MappingKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("mapping");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri</code> <code>eidUri</code>, or <code>null</code> if not present
     */
    @Nullable EidUri getEidUri();
    
    /**
     * Mapping origin
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin</code> <code>origin</code>, or <code>null</code> if not present
     */
    @Nullable MappingOrigin getOrigin();
    
    /**
     * Site ID
     *
     *
     *
     * @return <code>java.util.List</code> <code>siteId</code>, or <code>null</code> if not present
     */
    @Nullable List<SiteId> getSiteId();
    
    /**
     * A list of xTR-IDs with their associated mappings
     *
     *
     *
     * @return <code>java.util.List</code> <code>xtrIdMapping</code>, or <code>null</code> if not present
     */
    @Nullable List<XtrIdMapping> getXtrIdMapping();
    
    /**
     * @return <code>java.util.List</code> <code>xtrIdMapping</code>, or an empty list if it is not present
     */
    default @NonNull List<XtrIdMapping> nonnullXtrIdMapping() {
        return CodeHelpers.nonnull(getXtrIdMapping());
    }
    
    @Override
    MappingKey key();

}

