package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SiteId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link MappingBuilder} instances.
 *
 * @see MappingBuilder
 *
 */
public class MappingBuilder implements Builder<Mapping> {

    private EidUri _eidUri;
    private MappingRecord _mappingRecord;
    private MappingOrigin _origin;
    private List<SiteId> _siteId;
    private List<XtrIdMapping> _xtrIdMapping;
    private MappingKey key;


    Map<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>> augmentation = Collections.emptyMap();

    public MappingBuilder() {
    }
    public MappingBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public MappingBuilder(Mapping base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>> aug =((AugmentationHolder<Mapping>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this.key = base.key();
        this._eidUri = base.getEidUri();
        this._origin = base.getOrigin();
        this._mappingRecord = base.getMappingRecord();
        this._siteId = base.getSiteId();
        this._xtrIdMapping = base.getXtrIdMapping();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer) {
            this._mappingRecord = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer)arg).getMappingRecord();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer]");
    }

    public MappingKey key() {
        return key;
    }
    
    public EidUri getEidUri() {
        return _eidUri;
    }
    
    public MappingRecord getMappingRecord() {
        return _mappingRecord;
    }
    
    public MappingOrigin getOrigin() {
        return _origin;
    }
    
    public List<SiteId> getSiteId() {
        return _siteId;
    }
    
    public List<XtrIdMapping> getXtrIdMapping() {
        return _xtrIdMapping;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Mapping>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public MappingBuilder withKey(final MappingKey key) {
        this.key = key;
        return this;
    }
    
    public MappingBuilder setEidUri(final EidUri value) {
        this._eidUri = value;
        return this;
    }
    
    public MappingBuilder setMappingRecord(final MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }
    
    public MappingBuilder setOrigin(final MappingOrigin value) {
        this._origin = value;
        return this;
    }
    public MappingBuilder setSiteId(final List<SiteId> values) {
        this._siteId = values;
        return this;
    }
    
    public MappingBuilder setXtrIdMapping(final List<XtrIdMapping> values) {
        this._xtrIdMapping = values;
        return this;
    }
    
    
    public MappingBuilder addAugmentation(Class<? extends Augmentation<Mapping>> augmentationType, Augmentation<Mapping> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public MappingBuilder removeAugmentation(Class<? extends Augmentation<Mapping>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Mapping build() {
        return new MappingImpl(this);
    }

    private static final class MappingImpl
        extends AbstractAugmentable<Mapping>
        implements Mapping {
    
        private final EidUri _eidUri;
        private final MappingRecord _mappingRecord;
        private final MappingOrigin _origin;
        private final List<SiteId> _siteId;
        private final List<XtrIdMapping> _xtrIdMapping;
        private final MappingKey key;
    
        MappingImpl(MappingBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new MappingKey(base.getEidUri(), base.getOrigin());
            }
            this._eidUri = key.getEidUri();
            this._origin = key.getOrigin();
            this._mappingRecord = base.getMappingRecord();
            this._siteId = base.getSiteId();
            this._xtrIdMapping = base.getXtrIdMapping();
        }
    
        @Override
        public MappingKey key() {
            return key;
        }
        
        @Override
        public EidUri getEidUri() {
            return _eidUri;
        }
        
        @Override
        public MappingRecord getMappingRecord() {
            return _mappingRecord;
        }
        
        @Override
        public MappingOrigin getOrigin() {
            return _origin;
        }
        
        @Override
        public List<SiteId> getSiteId() {
            return _siteId;
        }
        
        @Override
        public List<XtrIdMapping> getXtrIdMapping() {
            return _xtrIdMapping;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_eidUri);
            result = prime * result + Objects.hashCode(_mappingRecord);
            result = prime * result + Objects.hashCode(_origin);
            result = prime * result + Objects.hashCode(_siteId);
            result = prime * result + Objects.hashCode(_xtrIdMapping);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Mapping.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Mapping other = (Mapping)obj;
            if (!Objects.equals(_eidUri, other.getEidUri())) {
                return false;
            }
            if (!Objects.equals(_mappingRecord, other.getMappingRecord())) {
                return false;
            }
            if (!Objects.equals(_origin, other.getOrigin())) {
                return false;
            }
            if (!Objects.equals(_siteId, other.getSiteId())) {
                return false;
            }
            if (!Objects.equals(_xtrIdMapping, other.getXtrIdMapping())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                MappingImpl otherImpl = (MappingImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Mapping");
            CodeHelpers.appendValue(helper, "_eidUri", _eidUri);
            CodeHelpers.appendValue(helper, "_mappingRecord", _mappingRecord);
            CodeHelpers.appendValue(helper, "_origin", _origin);
            CodeHelpers.appendValue(helper, "_siteId", _siteId);
            CodeHelpers.appendValue(helper, "_xtrIdMapping", _xtrIdMapping);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
