package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class MappingKey
 implements Identifier<Mapping> {
    private static final long serialVersionUID = -3556653507644188538L;
    private final EidUri _eidUri;
    private final MappingOrigin _origin;


    public MappingKey(EidUri _eidUri, MappingOrigin _origin) {
    
    
        this._eidUri = _eidUri;
        this._origin = _origin;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public MappingKey(MappingKey source) {
        this._eidUri = source._eidUri;
        this._origin = source._origin;
    }


    public EidUri getEidUri() {
        return _eidUri;
    }
    
    public MappingOrigin getOrigin() {
        return _origin;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_eidUri);
        result = prime * result + Objects.hashCode(_origin);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        MappingKey other = (MappingKey) obj;
        if (!Objects.equals(_eidUri, other._eidUri)) {
            return false;
        }
        if (!Objects.equals(_origin, other._origin)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(MappingKey.class);
        CodeHelpers.appendValue(helper, "_eidUri", _eidUri);
        CodeHelpers.appendValue(helper, "_origin", _origin);
        return helper.toString();
    }
}

