package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.XtrIdUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A list of xTR-IDs with their associated mappings
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * list xtr-id-mapping {
 *   config false;
 *   key xtr-id-uri;
 *   ext:context-instance xtrid-context;
 *   leaf xtr-id-uri {
 *     type xtr-id-uri;
 *   }
 *   uses lisp-proto:mapping-record-container;
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/db-instance/mapping/xtr-id-mapping</i>
 *
 * <p>To create instances of this class use {@link XtrIdMappingBuilder}.
 * @see XtrIdMappingBuilder
 * @see XtrIdMappingKey
 *
 */
public interface XtrIdMapping
    extends
    ChildOf<Mapping>,
    Augmentable<XtrIdMapping>,
    MappingRecordContainer,
    Identifiable<XtrIdMappingKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("xtr-id-mapping");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.XtrIdUri</code> <code>xtrIdUri</code>, or <code>null</code> if not present
     */
    @Nullable XtrIdUri getXtrIdUri();
    
    @Override
    XtrIdMappingKey key();

}

