package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.XtrIdUri;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link XtrIdMappingBuilder} instances.
 *
 * @see XtrIdMappingBuilder
 *
 */
public class XtrIdMappingBuilder implements Builder<XtrIdMapping> {

    private MappingRecord _mappingRecord;
    private XtrIdUri _xtrIdUri;
    private XtrIdMappingKey key;


    Map<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>> augmentation = Collections.emptyMap();

    public XtrIdMappingBuilder() {
    }
    public XtrIdMappingBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public XtrIdMappingBuilder(XtrIdMapping base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>> aug =((AugmentationHolder<XtrIdMapping>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this.key = base.key();
        this._xtrIdUri = base.getXtrIdUri();
        this._mappingRecord = base.getMappingRecord();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer) {
            this._mappingRecord = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer)arg).getMappingRecord();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer]");
    }

    public XtrIdMappingKey key() {
        return key;
    }
    
    public MappingRecord getMappingRecord() {
        return _mappingRecord;
    }
    
    public XtrIdUri getXtrIdUri() {
        return _xtrIdUri;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<XtrIdMapping>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public XtrIdMappingBuilder withKey(final XtrIdMappingKey key) {
        this.key = key;
        return this;
    }
    
    public XtrIdMappingBuilder setMappingRecord(final MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }
    
    public XtrIdMappingBuilder setXtrIdUri(final XtrIdUri value) {
        this._xtrIdUri = value;
        return this;
    }
    
    public XtrIdMappingBuilder addAugmentation(Class<? extends Augmentation<XtrIdMapping>> augmentationType, Augmentation<XtrIdMapping> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public XtrIdMappingBuilder removeAugmentation(Class<? extends Augmentation<XtrIdMapping>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public XtrIdMapping build() {
        return new XtrIdMappingImpl(this);
    }

    private static final class XtrIdMappingImpl
        extends AbstractAugmentable<XtrIdMapping>
        implements XtrIdMapping {
    
        private final MappingRecord _mappingRecord;
        private final XtrIdUri _xtrIdUri;
        private final XtrIdMappingKey key;
    
        XtrIdMappingImpl(XtrIdMappingBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new XtrIdMappingKey(base.getXtrIdUri());
            }
            this._xtrIdUri = key.getXtrIdUri();
            this._mappingRecord = base.getMappingRecord();
        }
    
        @Override
        public XtrIdMappingKey key() {
            return key;
        }
        
        @Override
        public MappingRecord getMappingRecord() {
            return _mappingRecord;
        }
        
        @Override
        public XtrIdUri getXtrIdUri() {
            return _xtrIdUri;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mappingRecord);
            result = prime * result + Objects.hashCode(_xtrIdUri);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!XtrIdMapping.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            XtrIdMapping other = (XtrIdMapping)obj;
            if (!Objects.equals(_mappingRecord, other.getMappingRecord())) {
                return false;
            }
            if (!Objects.equals(_xtrIdUri, other.getXtrIdUri())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                XtrIdMappingImpl otherImpl = (XtrIdMappingImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("XtrIdMapping");
            CodeHelpers.appendValue(helper, "_mappingRecord", _mappingRecord);
            CodeHelpers.appendValue(helper, "_xtrIdUri", _xtrIdUri);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
