package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.XtrIdUri;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class XtrIdMappingKey
 implements Identifier<XtrIdMapping> {
    private static final long serialVersionUID = -8832823683084686280L;
    private final XtrIdUri _xtrIdUri;


    public XtrIdMappingKey(XtrIdUri _xtrIdUri) {
    
    
        this._xtrIdUri = _xtrIdUri;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public XtrIdMappingKey(XtrIdMappingKey source) {
        this._xtrIdUri = source._xtrIdUri;
    }


    public XtrIdUri getXtrIdUri() {
        return _xtrIdUri;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_xtrIdUri);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        XtrIdMappingKey other = (XtrIdMappingKey) obj;
        if (!Objects.equals(_xtrIdUri, other._xtrIdUri)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(XtrIdMappingKey.class);
        CodeHelpers.appendValue(helper, "_xtrIdUri", _xtrIdUri);
        return helper.toString();
    }
}

