package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidAuthkeyList;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * list eid-authkey-item {
 *   key eid-authkey-item-id;
 *   leaf eid-authkey-item-id {
 *     type string;
 *   }
 *   uses lisp-proto:eid-container;
 *   uses lisp-proto:mapping-authkey-container;
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/eid-authkey-list/eid-authkey-item</i>
 *
 * <p>To create instances of this class use {@link EidAuthkeyItemBuilder}.
 * @see EidAuthkeyItemBuilder
 * @see EidAuthkeyItemKey
 *
 */
public interface EidAuthkeyItem
    extends
    ChildOf<EidAuthkeyList>,
    Augmentable<EidAuthkeyItem>,
    EidContainer,
    MappingAuthkeyContainer,
    Identifiable<EidAuthkeyItemKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("eid-authkey-item");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem.class;
    }
    
    /**
     * @return <code>java.lang.String</code> <code>eidAuthkeyItemId</code>, or <code>null</code> if not present
     */
    @Nullable String getEidAuthkeyItemId();
    
    @Override
    EidAuthkeyItemKey key();

}

