package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class EidAuthkeyItemKey
 implements Identifier<EidAuthkeyItem> {
    private static final long serialVersionUID = 3908499816011096474L;
    private final String _eidAuthkeyItemId;


    public EidAuthkeyItemKey(String _eidAuthkeyItemId) {
    
    
        this._eidAuthkeyItemId = _eidAuthkeyItemId;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public EidAuthkeyItemKey(EidAuthkeyItemKey source) {
        this._eidAuthkeyItemId = source._eidAuthkeyItemId;
    }


    public String getEidAuthkeyItemId() {
        return _eidAuthkeyItemId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_eidAuthkeyItemId);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        EidAuthkeyItemKey other = (EidAuthkeyItemKey) obj;
        if (!Objects.equals(_eidAuthkeyItemId, other._eidAuthkeyItemId)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(EidAuthkeyItemKey.class);
        CodeHelpers.appendValue(helper, "_eidAuthkeyItemId", _eidAuthkeyItemId);
        return helper.toString();
    }
}

