package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class MappingAuthkeyItemKey
 implements Identifier<MappingAuthkeyItem> {
    private static final long serialVersionUID = -1218215823410352147L;
    private final String _mappingAuthkeyItemId;


    public MappingAuthkeyItemKey(String _mappingAuthkeyItemId) {
    
    
        this._mappingAuthkeyItemId = _mappingAuthkeyItemId;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public MappingAuthkeyItemKey(MappingAuthkeyItemKey source) {
        this._mappingAuthkeyItemId = source._mappingAuthkeyItemId;
    }


    public String getMappingAuthkeyItemId() {
        return _mappingAuthkeyItemId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_mappingAuthkeyItemId);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        MappingAuthkeyItemKey other = (MappingAuthkeyItemKey) obj;
        if (!Objects.equals(_mappingAuthkeyItemId, other._mappingAuthkeyItemId)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(MappingAuthkeyItemKey.class);
        CodeHelpers.appendValue(helper, "_mappingAuthkeyItemId", _mappingAuthkeyItemId);
        return helper.toString();
    }
}

