package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.subscriber.data.grouping.SubscriberData;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstSubscriberItemBuilder} instances.
 *
 * @see DstSubscriberItemBuilder
 *
 */
public class DstSubscriberItemBuilder implements Builder<DstSubscriberItem> {

    private SubscriberData _subscriberData;


    Map<Class<? extends Augmentation<DstSubscriberItem>>, Augmentation<DstSubscriberItem>> augmentation = Collections.emptyMap();

    public DstSubscriberItemBuilder() {
    }
    public DstSubscriberItemBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SubscriberDataGrouping arg) {
        this._subscriberData = arg.getSubscriberData();
    }

    public DstSubscriberItemBuilder(DstSubscriberItem base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstSubscriberItem>>, Augmentation<DstSubscriberItem>> aug =((AugmentationHolder<DstSubscriberItem>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._subscriberData = base.getSubscriberData();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SubscriberDataGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SubscriberDataGrouping) {
            this._subscriberData = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SubscriberDataGrouping)arg).getSubscriberData();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SubscriberDataGrouping]");
    }

    public SubscriberData getSubscriberData() {
        return _subscriberData;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstSubscriberItem>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstSubscriberItemBuilder setSubscriberData(final SubscriberData value) {
        this._subscriberData = value;
        return this;
    }
    
    public DstSubscriberItemBuilder addAugmentation(Class<? extends Augmentation<DstSubscriberItem>> augmentationType, Augmentation<DstSubscriberItem> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstSubscriberItemBuilder removeAugmentation(Class<? extends Augmentation<DstSubscriberItem>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstSubscriberItem build() {
        return new DstSubscriberItemImpl(this);
    }

    private static final class DstSubscriberItemImpl
        extends AbstractAugmentable<DstSubscriberItem>
        implements DstSubscriberItem {
    
        private final SubscriberData _subscriberData;
    
        DstSubscriberItemImpl(DstSubscriberItemBuilder base) {
            super(base.augmentation);
            this._subscriberData = base.getSubscriberData();
        }
    
        @Override
        public SubscriberData getSubscriberData() {
            return _subscriberData;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_subscriberData);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstSubscriberItem.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            DstSubscriberItem other = (DstSubscriberItem)obj;
            if (!Objects.equals(_subscriberData, other.getSubscriberData())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstSubscriberItemImpl otherImpl = (DstSubscriberItemImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstSubscriberItem>>, Augmentation<DstSubscriberItem>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstSubscriberItem");
            CodeHelpers.appendValue(helper, "_subscriberData", _subscriberData);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
