package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.subscriber.data.grouping.SubscriberData;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SubscriberItemBuilder} instances.
 *
 * @see SubscriberItemBuilder
 *
 */
public class SubscriberItemBuilder implements Builder<SubscriberItem> {

    private SubscriberData _subscriberData;


    Map<Class<? extends Augmentation<SubscriberItem>>, Augmentation<SubscriberItem>> augmentation = Collections.emptyMap();

    public SubscriberItemBuilder() {
    }
    public SubscriberItemBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SubscriberDataGrouping arg) {
        this._subscriberData = arg.getSubscriberData();
    }

    public SubscriberItemBuilder(SubscriberItem base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SubscriberItem>>, Augmentation<SubscriberItem>> aug =((AugmentationHolder<SubscriberItem>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._subscriberData = base.getSubscriberData();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SubscriberDataGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SubscriberDataGrouping) {
            this._subscriberData = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SubscriberDataGrouping)arg).getSubscriberData();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SubscriberDataGrouping]");
    }

    public SubscriberData getSubscriberData() {
        return _subscriberData;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SubscriberItem>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SubscriberItemBuilder setSubscriberData(final SubscriberData value) {
        this._subscriberData = value;
        return this;
    }
    
    public SubscriberItemBuilder addAugmentation(Class<? extends Augmentation<SubscriberItem>> augmentationType, Augmentation<SubscriberItem> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SubscriberItemBuilder removeAugmentation(Class<? extends Augmentation<SubscriberItem>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SubscriberItem build() {
        return new SubscriberItemImpl(this);
    }

    private static final class SubscriberItemImpl
        extends AbstractAugmentable<SubscriberItem>
        implements SubscriberItem {
    
        private final SubscriberData _subscriberData;
    
        SubscriberItemImpl(SubscriberItemBuilder base) {
            super(base.augmentation);
            this._subscriberData = base.getSubscriberData();
        }
    
        @Override
        public SubscriberData getSubscriberData() {
            return _subscriberData;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_subscriberData);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SubscriberItem.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SubscriberItem other = (SubscriberItem)obj;
            if (!Objects.equals(_subscriberData, other.getSubscriberData())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SubscriberItemImpl otherImpl = (SubscriberItemImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SubscriberItem>>, Augmentation<SubscriberItem>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SubscriberItem");
            CodeHelpers.appendValue(helper, "_subscriberData", _subscriberData);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
