package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * container last-updated {
 *   config false;
 *   leaf last-updated {
 *     type int64;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/mapping-database/last-updated</i>
 *
 * <p>To create instances of this class use {@link LastUpdatedBuilder}.
 * @see LastUpdatedBuilder
 *
 */
public interface LastUpdated
    extends
    ChildOf<MappingDatabase>,
    Augmentable<LastUpdated>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("last-updated");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.LastUpdated> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.LastUpdated.class;
    }
    
    /**
     * Last database update timestamp (in milliseconds since January 1, 1970, 00:00:00 
     * GMT)
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>lastUpdated</code>, or <code>null</code> if not present
     */
    @Nullable Long getLastUpdated();

}

