package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link LastUpdatedBuilder} instances.
 *
 * @see LastUpdatedBuilder
 *
 */
public class LastUpdatedBuilder implements Builder<LastUpdated> {

    private Long _lastUpdated;


    Map<Class<? extends Augmentation<LastUpdated>>, Augmentation<LastUpdated>> augmentation = Collections.emptyMap();

    public LastUpdatedBuilder() {
    }

    public LastUpdatedBuilder(LastUpdated base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<LastUpdated>>, Augmentation<LastUpdated>> aug =((AugmentationHolder<LastUpdated>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._lastUpdated = base.getLastUpdated();
    }


    public Long getLastUpdated() {
        return _lastUpdated;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<LastUpdated>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public LastUpdatedBuilder setLastUpdated(final Long value) {
        this._lastUpdated = value;
        return this;
    }
    
    public LastUpdatedBuilder addAugmentation(Class<? extends Augmentation<LastUpdated>> augmentationType, Augmentation<LastUpdated> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public LastUpdatedBuilder removeAugmentation(Class<? extends Augmentation<LastUpdated>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public LastUpdated build() {
        return new LastUpdatedImpl(this);
    }

    private static final class LastUpdatedImpl
        extends AbstractAugmentable<LastUpdated>
        implements LastUpdated {
    
        private final Long _lastUpdated;
    
        LastUpdatedImpl(LastUpdatedBuilder base) {
            super(base.augmentation);
            this._lastUpdated = base.getLastUpdated();
        }
    
        @Override
        public Long getLastUpdated() {
            return _lastUpdated;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_lastUpdated);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LastUpdated.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            LastUpdated other = (LastUpdated)obj;
            if (!Objects.equals(_lastUpdated, other.getLastUpdated())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                LastUpdatedImpl otherImpl = (LastUpdatedImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<LastUpdated>>, Augmentation<LastUpdated>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("LastUpdated");
            CodeHelpers.appendValue(helper, "_lastUpdated", _lastUpdated);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
