package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A list of Virtual Network Identifiers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * list virtual-network-identifier {
 *   key vni;
 *   ext:context-instance vni-context;
 *   uses db-instance;
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/mapping-database/virtual-network-identifier</i>
 *
 * <p>To create instances of this class use {@link VirtualNetworkIdentifierBuilder}.
 * @see VirtualNetworkIdentifierBuilder
 * @see VirtualNetworkIdentifierKey
 *
 */
public interface VirtualNetworkIdentifier
    extends
    ChildOf<MappingDatabase>,
    Augmentable<VirtualNetworkIdentifier>,
    DbInstance,
    Identifiable<VirtualNetworkIdentifierKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("virtual-network-identifier");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier.class;
    }
    
    @Override
    VirtualNetworkIdentifierKey key();

}

