package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.VniUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link VirtualNetworkIdentifierBuilder} instances.
 *
 * @see VirtualNetworkIdentifierBuilder
 *
 */
public class VirtualNetworkIdentifierBuilder implements Builder<VirtualNetworkIdentifier> {

    private List<AuthenticationKey> _authenticationKey;
    private List<Mapping> _mapping;
    private VniUri _vni;
    private VirtualNetworkIdentifierKey key;


    Map<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>> augmentation = Collections.emptyMap();

    public VirtualNetworkIdentifierBuilder() {
    }
    public VirtualNetworkIdentifierBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance arg) {
        this._vni = arg.getVni();
        this._mapping = arg.getMapping();
        this._authenticationKey = arg.getAuthenticationKey();
    }

    public VirtualNetworkIdentifierBuilder(VirtualNetworkIdentifier base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>> aug =((AugmentationHolder<VirtualNetworkIdentifier>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this.key = base.key();
        this._vni = base.getVni();
        this._authenticationKey = base.getAuthenticationKey();
        this._mapping = base.getMapping();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance) {
            this._vni = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance)arg).getVni();
            this._mapping = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance)arg).getMapping();
            this._authenticationKey = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance)arg).getAuthenticationKey();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance]");
    }

    public VirtualNetworkIdentifierKey key() {
        return key;
    }
    
    public List<AuthenticationKey> getAuthenticationKey() {
        return _authenticationKey;
    }
    
    public List<Mapping> getMapping() {
        return _mapping;
    }
    
    public VniUri getVni() {
        return _vni;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<VirtualNetworkIdentifier>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public VirtualNetworkIdentifierBuilder withKey(final VirtualNetworkIdentifierKey key) {
        this.key = key;
        return this;
    }
    public VirtualNetworkIdentifierBuilder setAuthenticationKey(final List<AuthenticationKey> values) {
        this._authenticationKey = values;
        return this;
    }
    
    public VirtualNetworkIdentifierBuilder setMapping(final List<Mapping> values) {
        this._mapping = values;
        return this;
    }
    
    
    public VirtualNetworkIdentifierBuilder setVni(final VniUri value) {
        this._vni = value;
        return this;
    }
    
    public VirtualNetworkIdentifierBuilder addAugmentation(Class<? extends Augmentation<VirtualNetworkIdentifier>> augmentationType, Augmentation<VirtualNetworkIdentifier> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public VirtualNetworkIdentifierBuilder removeAugmentation(Class<? extends Augmentation<VirtualNetworkIdentifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public VirtualNetworkIdentifier build() {
        return new VirtualNetworkIdentifierImpl(this);
    }

    private static final class VirtualNetworkIdentifierImpl
        extends AbstractAugmentable<VirtualNetworkIdentifier>
        implements VirtualNetworkIdentifier {
    
        private final List<AuthenticationKey> _authenticationKey;
        private final List<Mapping> _mapping;
        private final VniUri _vni;
        private final VirtualNetworkIdentifierKey key;
    
        VirtualNetworkIdentifierImpl(VirtualNetworkIdentifierBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new VirtualNetworkIdentifierKey(base.getVni());
            }
            this._vni = key.getVni();
            this._authenticationKey = base.getAuthenticationKey();
            this._mapping = base.getMapping();
        }
    
        @Override
        public VirtualNetworkIdentifierKey key() {
            return key;
        }
        
        @Override
        public List<AuthenticationKey> getAuthenticationKey() {
            return _authenticationKey;
        }
        
        @Override
        public List<Mapping> getMapping() {
            return _mapping;
        }
        
        @Override
        public VniUri getVni() {
            return _vni;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_authenticationKey);
            result = prime * result + Objects.hashCode(_mapping);
            result = prime * result + Objects.hashCode(_vni);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VirtualNetworkIdentifier.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            VirtualNetworkIdentifier other = (VirtualNetworkIdentifier)obj;
            if (!Objects.equals(_authenticationKey, other.getAuthenticationKey())) {
                return false;
            }
            if (!Objects.equals(_mapping, other.getMapping())) {
                return false;
            }
            if (!Objects.equals(_vni, other.getVni())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                VirtualNetworkIdentifierImpl otherImpl = (VirtualNetworkIdentifierImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("VirtualNetworkIdentifier");
            CodeHelpers.appendValue(helper, "_authenticationKey", _authenticationKey);
            CodeHelpers.appendValue(helper, "_mapping", _mapping);
            CodeHelpers.appendValue(helper, "_vni", _vni);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
