package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.VniUri;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class VirtualNetworkIdentifierKey
 implements Identifier<VirtualNetworkIdentifier> {
    private static final long serialVersionUID = -3933872609824293399L;
    private final VniUri _vni;


    public VirtualNetworkIdentifierKey(VniUri _vni) {
    
    
        this._vni = _vni;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public VirtualNetworkIdentifierKey(VirtualNetworkIdentifierKey source) {
        this._vni = source._vni;
    }


    public VniUri getVni() {
        return _vni;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_vni);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        VirtualNetworkIdentifierKey other = (VirtualNetworkIdentifierKey) obj;
        if (!Objects.equals(_vni, other._vni)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(VirtualNetworkIdentifierKey.class);
        CodeHelpers.appendValue(helper, "_vni", _vni);
        return helper.toString();
    }
}

