/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MessageType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ControlMessageBuilder
implements Builder<ControlMessage> {
    private MessageType _msgType;
    private Long _rxCount;
    private Long _txCount;
    Map<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>> augmentation = Collections.emptyMap();

    public ControlMessageBuilder() {
    }

    public ControlMessageBuilder(ControlMessage base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>>(aug);
        }
        this._msgType = base.getMsgType();
        this._rxCount = base.getRxCount();
        this._txCount = base.getTxCount();
    }

    public MessageType getMsgType() {
        return this._msgType;
    }

    public Long getRxCount() {
        return this._rxCount;
    }

    public Long getTxCount() {
        return this._txCount;
    }

    public <E$$ extends Augmentation<ControlMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ControlMessageBuilder setMsgType(MessageType value) {
        this._msgType = value;
        return this;
    }

    public ControlMessageBuilder setRxCount(Long value) {
        this._rxCount = value;
        return this;
    }

    public ControlMessageBuilder setTxCount(Long value) {
        this._txCount = value;
        return this;
    }

    public ControlMessageBuilder addAugmentation(Class<? extends Augmentation<ControlMessage>> augmentationType, Augmentation<ControlMessage> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ControlMessageBuilder removeAugmentation(Class<? extends Augmentation<ControlMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ControlMessage build() {
        return new ControlMessageImpl(this);
    }

    private static final class ControlMessageImpl
    extends AbstractAugmentable<ControlMessage>
    implements ControlMessage {
        private final MessageType _msgType;
        private final Long _rxCount;
        private final Long _txCount;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ControlMessageImpl(ControlMessageBuilder base) {
            super(base.augmentation);
            this._msgType = base.getMsgType();
            this._rxCount = base.getRxCount();
            this._txCount = base.getTxCount();
        }

        @Override
        public MessageType getMsgType() {
            return this._msgType;
        }

        @Override
        public Long getRxCount() {
            return this._rxCount;
        }

        @Override
        public Long getTxCount() {
            return this._txCount;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._msgType);
            result = 31 * result + Objects.hashCode(this._rxCount);
            result = 31 * result + Objects.hashCode(this._txCount);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ControlMessage.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            ControlMessage other = (ControlMessage)obj;
            if (!Objects.equals(this._msgType, other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._rxCount, other.getRxCount())) {
                return false;
            }
            if (!Objects.equals(this._txCount, other.getTxCount())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ControlMessageImpl otherImpl = (ControlMessageImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ControlMessage");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_msgType", (Object)this._msgType);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_rxCount", (Object)this._rxCount);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_txCount", (Object)this._txCount);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

