/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum MappingChange implements Enumeration
{
    Created(0, "created"),
    Updated(1, "updated"),
    Removed(2, "removed");

    private static final Map<String, MappingChange> NAME_MAP;
    private static final Map<Integer, MappingChange> VALUE_MAP;
    private final String name;
    private final int value;

    private MappingChange(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<MappingChange> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static MappingChange forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (MappingChange enumItem : MappingChange.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

