/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChange;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.DstSubscriberItem;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.SubscriberItem;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MappingChangedBuilder
implements Builder<MappingChanged> {
    private MappingChange _changeType;
    private List<DstSubscriberItem> _dstSubscriberItem;
    private Eid _eid;
    private MappingRecord _mappingRecord;
    private List<SubscriberItem> _subscriberItem;
    Map<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>> augmentation = Collections.emptyMap();

    public MappingChangedBuilder() {
    }

    public MappingChangedBuilder(MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public MappingChangedBuilder(EidContainer arg) {
        this._eid = arg.getEid();
    }

    public MappingChangedBuilder(MappingChanged base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>>(aug);
        }
        this._changeType = base.getChangeType();
        this._dstSubscriberItem = base.getDstSubscriberItem();
        this._eid = base.getEid();
        this._mappingRecord = base.getMappingRecord();
        this._subscriberItem = base.getSubscriberItem();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EidContainer) {
            this._eid = ((EidContainer)arg).getEid();
            isValidArg = true;
        }
        if (arg instanceof MappingRecordContainer) {
            this._mappingRecord = ((MappingRecordContainer)arg).getMappingRecord();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer]");
    }

    public MappingChange getChangeType() {
        return this._changeType;
    }

    public List<DstSubscriberItem> getDstSubscriberItem() {
        return this._dstSubscriberItem;
    }

    public Eid getEid() {
        return this._eid;
    }

    public MappingRecord getMappingRecord() {
        return this._mappingRecord;
    }

    public List<SubscriberItem> getSubscriberItem() {
        return this._subscriberItem;
    }

    public <E$$ extends Augmentation<MappingChanged>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public MappingChangedBuilder setChangeType(MappingChange value) {
        this._changeType = value;
        return this;
    }

    public MappingChangedBuilder setDstSubscriberItem(List<DstSubscriberItem> values) {
        this._dstSubscriberItem = values;
        return this;
    }

    public MappingChangedBuilder setEid(Eid value) {
        this._eid = value;
        return this;
    }

    public MappingChangedBuilder setMappingRecord(MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }

    public MappingChangedBuilder setSubscriberItem(List<SubscriberItem> values) {
        this._subscriberItem = values;
        return this;
    }

    public MappingChangedBuilder addAugmentation(Class<? extends Augmentation<MappingChanged>> augmentationType, Augmentation<MappingChanged> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MappingChangedBuilder removeAugmentation(Class<? extends Augmentation<MappingChanged>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MappingChanged build() {
        return new MappingChangedImpl(this);
    }

    private static final class MappingChangedImpl
    extends AbstractAugmentable<MappingChanged>
    implements MappingChanged {
        private final MappingChange _changeType;
        private final List<DstSubscriberItem> _dstSubscriberItem;
        private final Eid _eid;
        private final MappingRecord _mappingRecord;
        private final List<SubscriberItem> _subscriberItem;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MappingChangedImpl(MappingChangedBuilder base) {
            super(base.augmentation);
            this._changeType = base.getChangeType();
            this._dstSubscriberItem = base.getDstSubscriberItem();
            this._eid = base.getEid();
            this._mappingRecord = base.getMappingRecord();
            this._subscriberItem = base.getSubscriberItem();
        }

        @Override
        public MappingChange getChangeType() {
            return this._changeType;
        }

        @Override
        public List<DstSubscriberItem> getDstSubscriberItem() {
            return this._dstSubscriberItem;
        }

        public Eid getEid() {
            return this._eid;
        }

        public MappingRecord getMappingRecord() {
            return this._mappingRecord;
        }

        @Override
        public List<SubscriberItem> getSubscriberItem() {
            return this._subscriberItem;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._changeType);
            result = 31 * result + Objects.hashCode(this._dstSubscriberItem);
            result = 31 * result + Objects.hashCode(this._eid);
            result = 31 * result + Objects.hashCode(this._mappingRecord);
            result = 31 * result + Objects.hashCode(this._subscriberItem);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MappingChanged.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            MappingChanged other = (MappingChanged)obj;
            if (!Objects.equals((Object)this._changeType, (Object)other.getChangeType())) {
                return false;
            }
            if (!Objects.equals(this._dstSubscriberItem, other.getDstSubscriberItem())) {
                return false;
            }
            if (!Objects.equals(this._eid, other.getEid())) {
                return false;
            }
            if (!Objects.equals(this._mappingRecord, other.getMappingRecord())) {
                return false;
            }
            if (!Objects.equals(this._subscriberItem, other.getSubscriberItem())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MappingChangedImpl otherImpl = (MappingChangedImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MappingChanged");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_changeType", (Object)((Object)this._changeType));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dstSubscriberItem", this._dstSubscriberItem);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_eid", (Object)this._eid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_mappingRecord", (Object)this._mappingRecord);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_subscriberItem", this._subscriberItem);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

