/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.LastUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MappingDatabaseBuilder
implements Builder<MappingDatabase> {
    private LastUpdated _lastUpdated;
    private List<VirtualNetworkIdentifier> _virtualNetworkIdentifier;
    Map<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> augmentation = Collections.emptyMap();

    public MappingDatabaseBuilder() {
    }

    public MappingDatabaseBuilder(MappingDatabase base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>(aug);
        }
        this._lastUpdated = base.getLastUpdated();
        this._virtualNetworkIdentifier = base.getVirtualNetworkIdentifier();
    }

    public LastUpdated getLastUpdated() {
        return this._lastUpdated;
    }

    public List<VirtualNetworkIdentifier> getVirtualNetworkIdentifier() {
        return this._virtualNetworkIdentifier;
    }

    public <E$$ extends Augmentation<MappingDatabase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public MappingDatabaseBuilder setLastUpdated(LastUpdated value) {
        this._lastUpdated = value;
        return this;
    }

    public MappingDatabaseBuilder setVirtualNetworkIdentifier(List<VirtualNetworkIdentifier> values) {
        this._virtualNetworkIdentifier = values;
        return this;
    }

    public MappingDatabaseBuilder addAugmentation(Class<? extends Augmentation<MappingDatabase>> augmentationType, Augmentation<MappingDatabase> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MappingDatabaseBuilder removeAugmentation(Class<? extends Augmentation<MappingDatabase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MappingDatabase build() {
        return new MappingDatabaseImpl(this);
    }

    private static final class MappingDatabaseImpl
    extends AbstractAugmentable<MappingDatabase>
    implements MappingDatabase {
        private final LastUpdated _lastUpdated;
        private final List<VirtualNetworkIdentifier> _virtualNetworkIdentifier;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MappingDatabaseImpl(MappingDatabaseBuilder base) {
            super(base.augmentation);
            this._lastUpdated = base.getLastUpdated();
            this._virtualNetworkIdentifier = base.getVirtualNetworkIdentifier();
        }

        @Override
        public LastUpdated getLastUpdated() {
            return this._lastUpdated;
        }

        @Override
        public List<VirtualNetworkIdentifier> getVirtualNetworkIdentifier() {
            return this._virtualNetworkIdentifier;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lastUpdated);
            result = 31 * result + Objects.hashCode(this._virtualNetworkIdentifier);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MappingDatabase.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            MappingDatabase other = (MappingDatabase)obj;
            if (!Objects.equals(this._lastUpdated, other.getLastUpdated())) {
                return false;
            }
            if (!Objects.equals(this._virtualNetworkIdentifier, other.getVirtualNetworkIdentifier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MappingDatabaseImpl otherImpl = (MappingDatabaseImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MappingDatabase");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_lastUpdated", (Object)this._lastUpdated);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_virtualNetworkIdentifier", this._virtualNetworkIdentifier);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

