/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKeyKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AuthenticationKeyBuilder
implements Builder<AuthenticationKey> {
    private Eid _eid;
    private EidUri _eidUri;
    private MappingAuthkey _mappingAuthkey;
    private AuthenticationKeyKey key;
    Map<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> augmentation = Collections.emptyMap();

    public AuthenticationKeyBuilder() {
    }

    public AuthenticationKeyBuilder(EidContainer arg) {
        this._eid = arg.getEid();
    }

    public AuthenticationKeyBuilder(MappingAuthkeyContainer arg) {
        this._mappingAuthkey = arg.getMappingAuthkey();
    }

    public AuthenticationKeyBuilder(AuthenticationKey base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>(aug);
        }
        this.key = base.key();
        this._eidUri = base.getEidUri();
        this._eid = base.getEid();
        this._mappingAuthkey = base.getMappingAuthkey();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EidContainer) {
            this._eid = ((EidContainer)arg).getEid();
            isValidArg = true;
        }
        if (arg instanceof MappingAuthkeyContainer) {
            this._mappingAuthkey = ((MappingAuthkeyContainer)arg).getMappingAuthkey();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer]");
    }

    public AuthenticationKeyKey key() {
        return this.key;
    }

    public Eid getEid() {
        return this._eid;
    }

    public EidUri getEidUri() {
        return this._eidUri;
    }

    public MappingAuthkey getMappingAuthkey() {
        return this._mappingAuthkey;
    }

    public <E$$ extends Augmentation<AuthenticationKey>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AuthenticationKeyBuilder withKey(AuthenticationKeyKey key) {
        this.key = key;
        return this;
    }

    public AuthenticationKeyBuilder setEid(Eid value) {
        this._eid = value;
        return this;
    }

    public AuthenticationKeyBuilder setEidUri(EidUri value) {
        this._eidUri = value;
        return this;
    }

    public AuthenticationKeyBuilder setMappingAuthkey(MappingAuthkey value) {
        this._mappingAuthkey = value;
        return this;
    }

    public AuthenticationKeyBuilder addAugmentation(Class<? extends Augmentation<AuthenticationKey>> augmentationType, Augmentation<AuthenticationKey> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AuthenticationKeyBuilder removeAugmentation(Class<? extends Augmentation<AuthenticationKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AuthenticationKey build() {
        return new AuthenticationKeyImpl(this);
    }

    private static final class AuthenticationKeyImpl
    extends AbstractAugmentable<AuthenticationKey>
    implements AuthenticationKey {
        private final Eid _eid;
        private final EidUri _eidUri;
        private final MappingAuthkey _mappingAuthkey;
        private final AuthenticationKeyKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        AuthenticationKeyImpl(AuthenticationKeyBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new AuthenticationKeyKey(base.getEidUri());
            this._eidUri = this.key.getEidUri();
            this._eid = base.getEid();
            this._mappingAuthkey = base.getMappingAuthkey();
        }

        @Override
        public AuthenticationKeyKey key() {
            return this.key;
        }

        public Eid getEid() {
            return this._eid;
        }

        @Override
        public EidUri getEidUri() {
            return this._eidUri;
        }

        public MappingAuthkey getMappingAuthkey() {
            return this._mappingAuthkey;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._eid);
            result = 31 * result + Objects.hashCode(this._eidUri);
            result = 31 * result + Objects.hashCode(this._mappingAuthkey);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AuthenticationKey.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            AuthenticationKey other = (AuthenticationKey)obj;
            if (!Objects.equals(this._eid, other.getEid())) {
                return false;
            }
            if (!Objects.equals(this._eidUri, other.getEidUri())) {
                return false;
            }
            if (!Objects.equals(this._mappingAuthkey, other.getMappingAuthkey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AuthenticationKeyImpl otherImpl = (AuthenticationKeyImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"AuthenticationKey");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_eid", (Object)this._eid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_eidUri", (Object)this._eidUri);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_mappingAuthkey", (Object)this._mappingAuthkey);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

