/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SiteId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.MappingKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MappingBuilder
implements Builder<Mapping> {
    private EidUri _eidUri;
    private MappingRecord _mappingRecord;
    private MappingOrigin _origin;
    private List<SiteId> _siteId;
    private List<XtrIdMapping> _xtrIdMapping;
    private MappingKey key;
    Map<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>> augmentation = Collections.emptyMap();

    public MappingBuilder() {
    }

    public MappingBuilder(MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public MappingBuilder(Mapping base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>>(aug);
        }
        this.key = base.key();
        this._eidUri = base.getEidUri();
        this._origin = base.getOrigin();
        this._mappingRecord = base.getMappingRecord();
        this._siteId = base.getSiteId();
        this._xtrIdMapping = base.getXtrIdMapping();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingRecordContainer) {
            this._mappingRecord = ((MappingRecordContainer)arg).getMappingRecord();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer]");
    }

    public MappingKey key() {
        return this.key;
    }

    public EidUri getEidUri() {
        return this._eidUri;
    }

    public MappingRecord getMappingRecord() {
        return this._mappingRecord;
    }

    public MappingOrigin getOrigin() {
        return this._origin;
    }

    public List<SiteId> getSiteId() {
        return this._siteId;
    }

    public List<XtrIdMapping> getXtrIdMapping() {
        return this._xtrIdMapping;
    }

    public <E$$ extends Augmentation<Mapping>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public MappingBuilder withKey(MappingKey key) {
        this.key = key;
        return this;
    }

    public MappingBuilder setEidUri(EidUri value) {
        this._eidUri = value;
        return this;
    }

    public MappingBuilder setMappingRecord(MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }

    public MappingBuilder setOrigin(MappingOrigin value) {
        this._origin = value;
        return this;
    }

    public MappingBuilder setSiteId(List<SiteId> values) {
        this._siteId = values;
        return this;
    }

    public MappingBuilder setXtrIdMapping(List<XtrIdMapping> values) {
        this._xtrIdMapping = values;
        return this;
    }

    public MappingBuilder addAugmentation(Class<? extends Augmentation<Mapping>> augmentationType, Augmentation<Mapping> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MappingBuilder removeAugmentation(Class<? extends Augmentation<Mapping>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Mapping build() {
        return new MappingImpl(this);
    }

    private static final class MappingImpl
    extends AbstractAugmentable<Mapping>
    implements Mapping {
        private final EidUri _eidUri;
        private final MappingRecord _mappingRecord;
        private final MappingOrigin _origin;
        private final List<SiteId> _siteId;
        private final List<XtrIdMapping> _xtrIdMapping;
        private final MappingKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MappingImpl(MappingBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new MappingKey(base.getEidUri(), base.getOrigin());
            this._eidUri = this.key.getEidUri();
            this._origin = this.key.getOrigin();
            this._mappingRecord = base.getMappingRecord();
            this._siteId = base.getSiteId();
            this._xtrIdMapping = base.getXtrIdMapping();
        }

        @Override
        public MappingKey key() {
            return this.key;
        }

        @Override
        public EidUri getEidUri() {
            return this._eidUri;
        }

        public MappingRecord getMappingRecord() {
            return this._mappingRecord;
        }

        @Override
        public MappingOrigin getOrigin() {
            return this._origin;
        }

        @Override
        public List<SiteId> getSiteId() {
            return this._siteId;
        }

        @Override
        public List<XtrIdMapping> getXtrIdMapping() {
            return this._xtrIdMapping;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._eidUri);
            result = 31 * result + Objects.hashCode(this._mappingRecord);
            result = 31 * result + Objects.hashCode((Object)this._origin);
            result = 31 * result + Objects.hashCode(this._siteId);
            result = 31 * result + Objects.hashCode(this._xtrIdMapping);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Mapping.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Mapping other = (Mapping)obj;
            if (!Objects.equals(this._eidUri, other.getEidUri())) {
                return false;
            }
            if (!Objects.equals(this._mappingRecord, other.getMappingRecord())) {
                return false;
            }
            if (!Objects.equals((Object)this._origin, (Object)other.getOrigin())) {
                return false;
            }
            if (!Objects.equals(this._siteId, other.getSiteId())) {
                return false;
            }
            if (!Objects.equals(this._xtrIdMapping, other.getXtrIdMapping())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MappingImpl otherImpl = (MappingImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Mapping");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_eidUri", (Object)this._eidUri);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_mappingRecord", (Object)this._mappingRecord);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_origin", (Object)((Object)this._origin));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_siteId", this._siteId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_xtrIdMapping", this._xtrIdMapping);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

