/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.VniUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifierKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VirtualNetworkIdentifierBuilder
implements Builder<VirtualNetworkIdentifier> {
    private List<AuthenticationKey> _authenticationKey;
    private List<Mapping> _mapping;
    private VniUri _vni;
    private VirtualNetworkIdentifierKey key;
    Map<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>> augmentation = Collections.emptyMap();

    public VirtualNetworkIdentifierBuilder() {
    }

    public VirtualNetworkIdentifierBuilder(DbInstance arg) {
        this._vni = arg.getVni();
        this._mapping = arg.getMapping();
        this._authenticationKey = arg.getAuthenticationKey();
    }

    public VirtualNetworkIdentifierBuilder(VirtualNetworkIdentifier base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>>(aug);
        }
        this.key = base.key();
        this._vni = base.getVni();
        this._authenticationKey = base.getAuthenticationKey();
        this._mapping = base.getMapping();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DbInstance) {
            this._vni = ((DbInstance)arg).getVni();
            this._mapping = ((DbInstance)arg).getMapping();
            this._authenticationKey = ((DbInstance)arg).getAuthenticationKey();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance]");
    }

    public VirtualNetworkIdentifierKey key() {
        return this.key;
    }

    public List<AuthenticationKey> getAuthenticationKey() {
        return this._authenticationKey;
    }

    public List<Mapping> getMapping() {
        return this._mapping;
    }

    public VniUri getVni() {
        return this._vni;
    }

    public <E$$ extends Augmentation<VirtualNetworkIdentifier>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public VirtualNetworkIdentifierBuilder withKey(VirtualNetworkIdentifierKey key) {
        this.key = key;
        return this;
    }

    public VirtualNetworkIdentifierBuilder setAuthenticationKey(List<AuthenticationKey> values) {
        this._authenticationKey = values;
        return this;
    }

    public VirtualNetworkIdentifierBuilder setMapping(List<Mapping> values) {
        this._mapping = values;
        return this;
    }

    public VirtualNetworkIdentifierBuilder setVni(VniUri value) {
        this._vni = value;
        return this;
    }

    public VirtualNetworkIdentifierBuilder addAugmentation(Class<? extends Augmentation<VirtualNetworkIdentifier>> augmentationType, Augmentation<VirtualNetworkIdentifier> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public VirtualNetworkIdentifierBuilder removeAugmentation(Class<? extends Augmentation<VirtualNetworkIdentifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VirtualNetworkIdentifier build() {
        return new VirtualNetworkIdentifierImpl(this);
    }

    private static final class VirtualNetworkIdentifierImpl
    extends AbstractAugmentable<VirtualNetworkIdentifier>
    implements VirtualNetworkIdentifier {
        private final List<AuthenticationKey> _authenticationKey;
        private final List<Mapping> _mapping;
        private final VniUri _vni;
        private final VirtualNetworkIdentifierKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        VirtualNetworkIdentifierImpl(VirtualNetworkIdentifierBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new VirtualNetworkIdentifierKey(base.getVni());
            this._vni = this.key.getVni();
            this._authenticationKey = base.getAuthenticationKey();
            this._mapping = base.getMapping();
        }

        @Override
        public VirtualNetworkIdentifierKey key() {
            return this.key;
        }

        @Override
        public List<AuthenticationKey> getAuthenticationKey() {
            return this._authenticationKey;
        }

        @Override
        public List<Mapping> getMapping() {
            return this._mapping;
        }

        @Override
        public VniUri getVni() {
            return this._vni;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._authenticationKey);
            result = 31 * result + Objects.hashCode(this._mapping);
            result = 31 * result + Objects.hashCode(this._vni);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VirtualNetworkIdentifier.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            VirtualNetworkIdentifier other = (VirtualNetworkIdentifier)obj;
            if (!Objects.equals(this._authenticationKey, other.getAuthenticationKey())) {
                return false;
            }
            if (!Objects.equals(this._mapping, other.getMapping())) {
                return false;
            }
            if (!Objects.equals(this._vni, other.getVni())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VirtualNetworkIdentifierImpl otherImpl = (VirtualNetworkIdentifierImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"VirtualNetworkIdentifier");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_authenticationKey", this._authenticationKey);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_mapping", this._mapping);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_vni", (Object)this._vni);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

