/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.LastUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.LastUpdatedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifierKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class MappingDatabaseBuilder {
    private LastUpdated _lastUpdated;
    private Map<VirtualNetworkIdentifierKey, VirtualNetworkIdentifier> _virtualNetworkIdentifier;
    Map<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> augmentation = Map.of();

    public MappingDatabaseBuilder() {
    }

    public MappingDatabaseBuilder(MappingDatabase base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>(aug);
        }
        this._lastUpdated = base.getLastUpdated();
        this._virtualNetworkIdentifier = base.getVirtualNetworkIdentifier();
    }

    public static @NonNull MappingDatabase empty() {
        return LazyEmpty.INSTANCE;
    }

    public LastUpdated getLastUpdated() {
        return this._lastUpdated;
    }

    public Map<VirtualNetworkIdentifierKey, VirtualNetworkIdentifier> getVirtualNetworkIdentifier() {
        return this._virtualNetworkIdentifier;
    }

    public <E$$ extends Augmentation<MappingDatabase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MappingDatabaseBuilder setLastUpdated(LastUpdated value) {
        this._lastUpdated = value;
        return this;
    }

    public MappingDatabaseBuilder setVirtualNetworkIdentifier(Map<VirtualNetworkIdentifierKey, VirtualNetworkIdentifier> values) {
        this._virtualNetworkIdentifier = values;
        return this;
    }

    public MappingDatabaseBuilder addAugmentation(Augmentation<MappingDatabase> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MappingDatabaseBuilder removeAugmentation(Class<? extends Augmentation<MappingDatabase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull MappingDatabase build() {
        return new MappingDatabaseImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull MappingDatabase INSTANCE = new MappingDatabaseBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class MappingDatabaseImpl
    extends AbstractAugmentable<MappingDatabase>
    implements MappingDatabase {
        private final LastUpdated _lastUpdated;
        private final Map<VirtualNetworkIdentifierKey, VirtualNetworkIdentifier> _virtualNetworkIdentifier;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MappingDatabaseImpl(MappingDatabaseBuilder base) {
            super(base.augmentation);
            this._lastUpdated = base.getLastUpdated();
            this._virtualNetworkIdentifier = CodeHelpers.emptyToNull(base.getVirtualNetworkIdentifier());
        }

        @Override
        public LastUpdated getLastUpdated() {
            return this._lastUpdated;
        }

        @Override
        public Map<VirtualNetworkIdentifierKey, VirtualNetworkIdentifier> getVirtualNetworkIdentifier() {
            return this._virtualNetworkIdentifier;
        }

        @Override
        public LastUpdated nonnullLastUpdated() {
            return Objects.requireNonNullElse(this.getLastUpdated(), LastUpdatedBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = MappingDatabase.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return MappingDatabase.bindingEquals(this, obj);
        }

        public String toString() {
            return MappingDatabase.bindingToString(this);
        }
    }
}

