/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.VniUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKeyKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.MappingKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifierKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VirtualNetworkIdentifierBuilder {
    private Map<AuthenticationKeyKey, AuthenticationKey> _authenticationKey;
    private Map<MappingKey, Mapping> _mapping;
    private VniUri _vni;
    private VirtualNetworkIdentifierKey key;
    Map<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>> augmentation = Map.of();

    public VirtualNetworkIdentifierBuilder() {
    }

    public VirtualNetworkIdentifierBuilder(DbInstance arg) {
        this._vni = arg.getVni();
        this._mapping = arg.getMapping();
        this._authenticationKey = arg.getAuthenticationKey();
    }

    public VirtualNetworkIdentifierBuilder(VirtualNetworkIdentifier base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>>(aug);
        }
        this.key = base.key();
        this._vni = base.getVni();
        this._authenticationKey = base.getAuthenticationKey();
        this._mapping = base.getMapping();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DbInstance) {
            DbInstance castArg = (DbInstance)arg;
            this._vni = castArg.getVni();
            this._mapping = castArg.getMapping();
            this._authenticationKey = castArg.getAuthenticationKey();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[DbInstance]");
    }

    public VirtualNetworkIdentifierKey key() {
        return this.key;
    }

    public Map<AuthenticationKeyKey, AuthenticationKey> getAuthenticationKey() {
        return this._authenticationKey;
    }

    public Map<MappingKey, Mapping> getMapping() {
        return this._mapping;
    }

    public VniUri getVni() {
        return this._vni;
    }

    public <E$$ extends Augmentation<VirtualNetworkIdentifier>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public VirtualNetworkIdentifierBuilder withKey(VirtualNetworkIdentifierKey key) {
        this.key = key;
        return this;
    }

    public VirtualNetworkIdentifierBuilder setAuthenticationKey(Map<AuthenticationKeyKey, AuthenticationKey> values) {
        this._authenticationKey = values;
        return this;
    }

    public VirtualNetworkIdentifierBuilder setMapping(Map<MappingKey, Mapping> values) {
        this._mapping = values;
        return this;
    }

    public VirtualNetworkIdentifierBuilder setVni(VniUri value) {
        this._vni = value;
        return this;
    }

    public VirtualNetworkIdentifierBuilder addAugmentation(Augmentation<VirtualNetworkIdentifier> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public VirtualNetworkIdentifierBuilder removeAugmentation(Class<? extends Augmentation<VirtualNetworkIdentifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull VirtualNetworkIdentifier build() {
        return new VirtualNetworkIdentifierImpl(this);
    }

    private static final class VirtualNetworkIdentifierImpl
    extends AbstractAugmentable<VirtualNetworkIdentifier>
    implements VirtualNetworkIdentifier {
        private final Map<AuthenticationKeyKey, AuthenticationKey> _authenticationKey;
        private final Map<MappingKey, Mapping> _mapping;
        private final VniUri _vni;
        private final VirtualNetworkIdentifierKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        VirtualNetworkIdentifierImpl(VirtualNetworkIdentifierBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new VirtualNetworkIdentifierKey(base.getVni());
            this._vni = this.key.getVni();
            this._authenticationKey = CodeHelpers.emptyToNull(base.getAuthenticationKey());
            this._mapping = CodeHelpers.emptyToNull(base.getMapping());
        }

        @Override
        public VirtualNetworkIdentifierKey key() {
            return this.key;
        }

        @Override
        public Map<AuthenticationKeyKey, AuthenticationKey> getAuthenticationKey() {
            return this._authenticationKey;
        }

        @Override
        public Map<MappingKey, Mapping> getMapping() {
            return this._mapping;
        }

        @Override
        public VniUri getVni() {
            return this._vni;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = VirtualNetworkIdentifier.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return VirtualNetworkIdentifier.bindingEquals(this, obj);
        }

        public String toString() {
            return VirtualNetworkIdentifier.bindingToString(this);
        }
    }
}

