package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * grouping cache-stats {
 *   leaf hits {
 *     type int64;
 *   }
 *   leaf misses {
 *     type int64;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface CacheStats
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("cache-stats");

    @Override
    Class<? extends CacheStats> implementedInterface();
    
    /**
     * Return hits, or {@code null} if it is not present.
     *
     * @return {@code Long} hits, or {@code null} if it is not present.
     *
     */
    Long getHits();
    
    /**
     * Return hits, guaranteed to be non-null.
     *
     * @return {@code Long} hits, guaranteed to be non-null.
     * @throws NoSuchElementException if hits is not present
     *
     */
    default @NonNull Long requireHits() {
        return CodeHelpers.require(getHits(), "hits");
    }
    
    /**
     * Return misses, or {@code null} if it is not present.
     *
     * @return {@code Long} misses, or {@code null} if it is not present.
     *
     */
    Long getMisses();
    
    /**
     * Return misses, guaranteed to be non-null.
     *
     * @return {@code Long} misses, guaranteed to be non-null.
     * @throws NoSuchElementException if misses is not present
     *
     */
    default @NonNull Long requireMisses() {
        return CodeHelpers.require(getMisses(), "misses");
    }

}

