package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * grouping ctrl-msg-stats {
 *   leaf rx-unknown {
 *     type int64;
 *   }
 *   leaf tx-errors {
 *     type int64;
 *   }
 *   list control-message {
 *     ordered-by user;
 *     leaf msg-type {
 *       type lisp-proto:message-type;
 *     }
 *     leaf rx-count {
 *       type int64;
 *     }
 *     leaf tx-count {
 *       type int64;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface CtrlMsgStats
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ctrl-msg-stats");

    @Override
    Class<? extends CtrlMsgStats> implementedInterface();
    
    /**
     * Return rxUnknown, or {@code null} if it is not present.
     *
     * @return {@code Long} rxUnknown, or {@code null} if it is not present.
     *
     */
    Long getRxUnknown();
    
    /**
     * Return rxUnknown, guaranteed to be non-null.
     *
     * @return {@code Long} rxUnknown, guaranteed to be non-null.
     * @throws NoSuchElementException if rxUnknown is not present
     *
     */
    default @NonNull Long requireRxUnknown() {
        return CodeHelpers.require(getRxUnknown(), "rxunknown");
    }
    
    /**
     * Return txErrors, or {@code null} if it is not present.
     *
     * @return {@code Long} txErrors, or {@code null} if it is not present.
     *
     */
    Long getTxErrors();
    
    /**
     * Return txErrors, guaranteed to be non-null.
     *
     * @return {@code Long} txErrors, guaranteed to be non-null.
     * @throws NoSuchElementException if txErrors is not present
     *
     */
    default @NonNull Long requireTxErrors() {
        return CodeHelpers.require(getTxErrors(), "txerrors");
    }
    
    /**
     * Return controlMessage, or {@code null} if it is not present.
     *
     * @return {@code List<ControlMessage>} controlMessage, or {@code null} if it is not present.
     *
     */
    @Nullable List<ControlMessage> getControlMessage();
    
    /**
     * Return controlMessage, or an empty list if it is not present.
     *
     * @return {@code List<ControlMessage>} controlMessage, or an empty list if it is not present.
     *
     */
    default @NonNull List<ControlMessage> nonnullControlMessage() {
        return CodeHelpers.nonnull(getControlMessage());
    }

}

