package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapreplymessage.MapReply;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.transport.address.TransportAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SendMapReplyInput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SendMapReplyInput createSendMapReplyInput(int fooXyzzy, int barBaz) {
 *         return new SendMapReplyInputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SendMapReplyInput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SendMapReplyInput
 *
 */
@Generated("mdsal-binding-generator")
public class SendMapReplyInputBuilder {

    private MapReply _mapReply;
    private TransportAddress _transportAddress;


    Map<Class<? extends Augmentation<SendMapReplyInput>>, Augmentation<SendMapReplyInput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SendMapReplyInputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link MapReplyMessage}.
     *
     * @param arg MapReplyMessage from which the builder should be initialized
     */
    public SendMapReplyInputBuilder(MapReplyMessage arg) {
        this._mapReply = arg.getMapReply();
        this._transportAddress = arg.getTransportAddress();
    }
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress from which the builder should be initialized
     */
    public SendMapReplyInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress arg) {
        this._transportAddress = arg.getTransportAddress();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link SendMapReplyInput}.
     *
     * @param base SendMapReplyInput from which the builder should be initialized
     */
    public SendMapReplyInputBuilder(SendMapReplyInput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._mapReply = base.getMapReply();
        this._transportAddress = base.getTransportAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link MapReplyMessage}</li>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MapReplyMessage castArg) {
            this._mapReply = castArg.getMapReply();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress castArg) {
            this._transportAddress = castArg.getTransportAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[MapReplyMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress]");
    }


    /**
     * Return current value associated with the property corresponding to {@link SendMapReplyInput#getMapReply()}.
     *
     * @return current value
     */
    public MapReply getMapReply() {
        return _mapReply;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SendMapReplyInput#getTransportAddress()}.
     *
     * @return current value
     */
    public TransportAddress getTransportAddress() {
        return _transportAddress;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SendMapReplyInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link SendMapReplyInput#getMapReply()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SendMapReplyInputBuilder setMapReply(final MapReply value) {
        this._mapReply = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SendMapReplyInput#getTransportAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SendMapReplyInputBuilder setTransportAddress(final TransportAddress value) {
        this._transportAddress = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SendMapReplyInputBuilder addAugmentation(Augmentation<SendMapReplyInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SendMapReplyInputBuilder removeAugmentation(Class<? extends Augmentation<SendMapReplyInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link SendMapReplyInput} instance.
     *
     * @return A new {@link SendMapReplyInput} instance.
     */
    public @NonNull SendMapReplyInput build() {
        return new SendMapReplyInputImpl(this);
    }

    private static final class SendMapReplyInputImpl
        extends AbstractAugmentable<SendMapReplyInput>
        implements SendMapReplyInput {
    
        private final MapReply _mapReply;
        private final TransportAddress _transportAddress;
    
        SendMapReplyInputImpl(SendMapReplyInputBuilder base) {
            super(base.augmentation);
            this._mapReply = base.getMapReply();
            this._transportAddress = base.getTransportAddress();
        }
    
        @Override
        public MapReply getMapReply() {
            return _mapReply;
        }
        
        @Override
        public TransportAddress getTransportAddress() {
            return _transportAddress;
        }
    
        @Override
        public MapReply nonnullMapReply() {
            return Objects.requireNonNullElse(getMapReply(), org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapreplymessage.MapReplyBuilder.empty());
        }
        
        @Override
        public TransportAddress nonnullTransportAddress() {
            return Objects.requireNonNullElse(getTransportAddress(), org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.transport.address.TransportAddressBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SendMapReplyInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SendMapReplyInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SendMapReplyInput.bindingToString(this);
        }
    }
}
