package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapRequestMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.maprequestmessage.MapRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.transport.address.TransportAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SendMapRequestInput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SendMapRequestInput createSendMapRequestInput(int fooXyzzy, int barBaz) {
 *         return new SendMapRequestInputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SendMapRequestInput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SendMapRequestInput
 *
 */
@Generated("mdsal-binding-generator")
public class SendMapRequestInputBuilder {

    private MapRequest _mapRequest;
    private TransportAddress _transportAddress;


    Map<Class<? extends Augmentation<SendMapRequestInput>>, Augmentation<SendMapRequestInput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SendMapRequestInputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link MapRequestMessage}.
     *
     * @param arg MapRequestMessage from which the builder should be initialized
     */
    public SendMapRequestInputBuilder(MapRequestMessage arg) {
        this._mapRequest = arg.getMapRequest();
        this._transportAddress = arg.getTransportAddress();
    }
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress from which the builder should be initialized
     */
    public SendMapRequestInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress arg) {
        this._transportAddress = arg.getTransportAddress();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link SendMapRequestInput}.
     *
     * @param base SendMapRequestInput from which the builder should be initialized
     */
    public SendMapRequestInputBuilder(SendMapRequestInput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._mapRequest = base.getMapRequest();
        this._transportAddress = base.getTransportAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link MapRequestMessage}</li>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MapRequestMessage castArg) {
            this._mapRequest = castArg.getMapRequest();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress castArg) {
            this._transportAddress = castArg.getTransportAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[MapRequestMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress]");
    }


    /**
     * Return current value associated with the property corresponding to {@link SendMapRequestInput#getMapRequest()}.
     *
     * @return current value
     */
    public MapRequest getMapRequest() {
        return _mapRequest;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SendMapRequestInput#getTransportAddress()}.
     *
     * @return current value
     */
    public TransportAddress getTransportAddress() {
        return _transportAddress;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SendMapRequestInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link SendMapRequestInput#getMapRequest()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SendMapRequestInputBuilder setMapRequest(final MapRequest value) {
        this._mapRequest = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SendMapRequestInput#getTransportAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SendMapRequestInputBuilder setTransportAddress(final TransportAddress value) {
        this._transportAddress = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SendMapRequestInputBuilder addAugmentation(Augmentation<SendMapRequestInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SendMapRequestInputBuilder removeAugmentation(Class<? extends Augmentation<SendMapRequestInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link SendMapRequestInput} instance.
     *
     * @return A new {@link SendMapRequestInput} instance.
     */
    public @NonNull SendMapRequestInput build() {
        return new SendMapRequestInputImpl(this);
    }

    private static final class SendMapRequestInputImpl
        extends AbstractAugmentable<SendMapRequestInput>
        implements SendMapRequestInput {
    
        private final MapRequest _mapRequest;
        private final TransportAddress _transportAddress;
    
        SendMapRequestInputImpl(SendMapRequestInputBuilder base) {
            super(base.augmentation);
            this._mapRequest = base.getMapRequest();
            this._transportAddress = base.getTransportAddress();
        }
    
        @Override
        public MapRequest getMapRequest() {
            return _mapRequest;
        }
        
        @Override
        public TransportAddress getTransportAddress() {
            return _transportAddress;
        }
    
        @Override
        public MapRequest nonnullMapRequest() {
            return Objects.requireNonNullElse(getMapRequest(), org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.maprequestmessage.MapRequestBuilder.empty());
        }
        
        @Override
        public TransportAddress nonnullTransportAddress() {
            return Objects.requireNonNullElse(getTransportAddress(), org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.transport.address.TransportAddressBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SendMapRequestInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SendMapRequestInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SendMapRequestInput.bindingToString(this);
        }
    }
}
