package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MessageType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * list control-message {
 *   ordered-by user;
 *   leaf msg-type {
 *     type lisp-proto:message-type;
 *   }
 *   leaf rx-count {
 *     type int64;
 *   }
 *   leaf tx-count {
 *     type int64;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ControlMessageBuilder}.
 * @see ControlMessageBuilder
 *
 *
 */
@Generated("mdsal-binding-generator")
public interface ControlMessage
    extends
    ChildOf<CtrlMsgStats>,
    Augmentable<ControlMessage>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("control-message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.@NonNull ControlMessage obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getMsgType());
        result = prime * result + Objects.hashCode(obj.getRxCount());
        result = prime * result + Objects.hashCode(obj.getTxCount());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.@NonNull ControlMessage thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage.class, obj);
        return other != null
            && Objects.equals(thisObj.getRxCount(), other.getRxCount())
            && Objects.equals(thisObj.getTxCount(), other.getTxCount())
            && Objects.equals(thisObj.getMsgType(), other.getMsgType())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.@NonNull ControlMessage obj) {
        final var helper = MoreObjects.toStringHelper("ControlMessage");
        CodeHelpers.appendValue(helper, "msgType", obj.getMsgType());
        CodeHelpers.appendValue(helper, "rxCount", obj.getRxCount());
        CodeHelpers.appendValue(helper, "txCount", obj.getTxCount());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return msgType, or {@code null} if it is not present.
     *
     * @return {@code MessageType} msgType, or {@code null} if it is not present.
     *
     */
    MessageType getMsgType();
    
    /**
     * Return msgType, guaranteed to be non-null.
     *
     * @return {@code MessageType} msgType, guaranteed to be non-null.
     * @throws NoSuchElementException if msgType is not present
     *
     */
    default @NonNull MessageType requireMsgType() {
        return CodeHelpers.require(getMsgType(), "msgtype");
    }
    
    /**
     * Return rxCount, or {@code null} if it is not present.
     *
     * @return {@code Long} rxCount, or {@code null} if it is not present.
     *
     */
    Long getRxCount();
    
    /**
     * Return rxCount, guaranteed to be non-null.
     *
     * @return {@code Long} rxCount, guaranteed to be non-null.
     * @throws NoSuchElementException if rxCount is not present
     *
     */
    default @NonNull Long requireRxCount() {
        return CodeHelpers.require(getRxCount(), "rxcount");
    }
    
    /**
     * Return txCount, or {@code null} if it is not present.
     *
     * @return {@code Long} txCount, or {@code null} if it is not present.
     *
     */
    Long getTxCount();
    
    /**
     * Return txCount, guaranteed to be non-null.
     *
     * @return {@code Long} txCount, guaranteed to be non-null.
     * @throws NoSuchElementException if txCount is not present
     *
     */
    default @NonNull Long requireTxCount() {
        return CodeHelpers.require(getTxCount(), "txcount");
    }

}

